package info.u_team.oauth_account_manager.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse.BodyHandlers;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import org.slf4j.LoggerFactory;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.minecraft.UserApiService.UserProperties;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.util.UndashedUuid;

import info.u_team.oauth_account_manager.OAuthAccountManagerReference;
import net.hycrafthd.simple_minecraft_authenticator.SimpleMinecraftAuthentication;
import net.hycrafthd.simple_minecraft_authenticator.method.AuthenticationMethod;
import net.minecraft.class_156;
import net.minecraft.class_2983;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_4341;
import net.minecraft.class_5520;
import net.minecraft.class_6628;
import net.minecraft.class_7569;
import net.minecraft.class_7574;
import net.minecraft.class_7578;
import net.minecraft.class_7853;
import net.minecraft.class_8647;

public class AuthenticationUtil {
	
	private static final HttpClient CLIENT = HttpClient.newHttpClient();
	
	public static CompletableFuture<Boolean> isAccessTokenValid(String accessToken) {
		final URI uri;
		try {
			uri = new URI(OAuthAccountManagerReference.ACCESS_TOKEN_VALID_ENDPOINT);
		} catch (URISyntaxException ex) {
			throw new AssertionError(ex);
		}
		
		final HttpRequest request = HttpRequest.newBuilder(uri) //
				.header("Authorization", "Bearer " + accessToken) //
				.timeout(Duration.ofSeconds(15)) //
				.GET() //
				.build();
		
		return CLIENT.sendAsync(request, BodyHandlers.discarding()).thenApply(response -> response.statusCode() == 200);
	}
	
	public static AuthenticationMethod createWebAuthenticationMethod() {
		return SimpleMinecraftAuthentication.getMethod("web").get().create(new class_2983("OAuth-Account-Manager", System.out), System.in);
	}
	
	public static MinecraftAccountData createMinecraftAccountData(LoadedAccount loadedAccount) throws AuthenticationException {
		final class_310 minecraft = class_310.method_1551();
		
		final var msUser = loadedAccount.user();
		
		final class_320 user = new class_320(msUser.name(), UndashedUuid.fromStringLenient(msUser.uuid()), msUser.accessToken(), Optional.of(msUser.xuid()), Optional.of(msUser.clientId()), class_320.class_321.method_1679(msUser.type()));
		final CompletableFuture<ProfileResult> profileFuture = CompletableFuture.supplyAsync(() -> minecraft.method_1495().fetchProfile(user.method_44717(), true), class_156.method_55473());
		final UserApiService userApiService = minecraft.field_39420.createUserApiService(msUser.accessToken());
		final CompletableFuture<UserProperties> userPropertiesFuture = CompletableFuture.supplyAsync(() -> {
			try {
				return userApiService.fetchProperties();
			} catch (final AuthenticationException ex) {
				LoggerFactory.getLogger(class_310.class).error("Failed to fetch user properties", ex);
				return UserApiService.OFFLINE_PROPERTIES;
			}
		}, class_156.method_55473());
		final class_5520 playerSocialManager = new class_5520(minecraft, userApiService);
		final class_6628 clientTelemetryManager = new class_6628(minecraft, userApiService, user);
		final class_7853 profileKeyPairManager = class_7853.method_46532(userApiService, user, minecraft.field_1697.toPath());
		final class_7574 reportingContext = class_7574.method_44599(class_7569.method_44586(), userApiService);
		
		return new MinecraftAccountData(user, profileFuture, userApiService, userPropertiesFuture, playerSocialManager, clientTelemetryManager, profileKeyPairManager, reportingContext);
	}
	
	public static void setMinecraftAccountData(MinecraftAccountData data) {
		final class_310 minecraft = class_310.method_1551();
		
		minecraft.field_1726 = data.user;
		minecraft.field_45899 = data.profileFuture;
		minecraft.field_26902 = data.userApiService;
		minecraft.field_47680 = data.userPropertiesFuture;
		minecraft.method_18095().field_18934 = data.user;
		minecraft.field_26842 = data.playerSocialManager;
		minecraft.field_41331 = data.telemetryManager;
		minecraft.field_39068 = data.profileKeyPairManager;
		minecraft.field_39492 = data.reportingContext;
		
		final class_4341 realmsClient = class_4341.method_20989(minecraft);
		minecraft.field_39718 = new class_7578(realmsClient);
		class_8647.field_45183 = null; // Force refresh realms
	}
	
	public static record MinecraftAccountData(class_320 user, CompletableFuture<ProfileResult> profileFuture, UserApiService userApiService, CompletableFuture<UserProperties> userPropertiesFuture, class_5520 playerSocialManager, class_6628 telemetryManager, class_7853 profileKeyPairManager, class_7574 reportingContext) {
	}
}
