package info.u_team.oauth_account_manager.screen.widget;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_7532;
import com.mojang.authlib.GameProfile;

import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.util.WidgetUtil;

public class PlayerIconWidget extends class_339 implements PerspectiveRenderable, TooltipRenderable {
	
	private final class_310 minecraft = class_310.method_1551();
	
	private GameProfile profile;
	
	public PlayerIconWidget(int x, int y, int size, GameProfile profile) {
		super(x, y, size, size, class_5244.field_39003);
		this.profile = profile;
	}
	
	public void setProfile(GameProfile profile) {
		this.profile = profile;
	}
	
	public GameProfile getProfile() {
		return profile;
	}
	
	@Override
	public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		if (profile != null) {
			renderBehind(guiGraphics, mouseX, mouseY, partialTick);
			renderBefore(guiGraphics, mouseX, mouseY, partialTick);
			WidgetUtil.renderCustomTooltipForWidget(this, guiGraphics, mouseX, mouseY, partialTick);
		}
	}
	
	@Override
	public void renderBefore(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		final class_2960 skin = minecraft.method_1582().method_52862(profile).comp_1626();
		
		class_7532.method_44445(guiGraphics, skin, method_46426(), method_46427(), method_25368(), false, false);
	}
	
	@Override
	public void renderBehind(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
	}
	
	@Override
	public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		if (field_22762) {
			guiGraphics.method_51437(minecraft.field_1772, List.of(class_2561.method_43470(profile.getName())), Optional.empty(), mouseX, mouseY);
		}
	}
	
	@Override
	protected void method_47399(class_6382 element) {
		method_37021(element);
	}
	
	@Override
	public void method_25354(class_1144 pHandler) {
		// Don't play click sound
	}
	
}
