package info.u_team.oauth_account_manager.screen.widget;

import info.u_team.oauth_account_manager.OAuthAccountManagerReference;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.class_1144;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_7833;

public class LoadingSpinnerWidget extends class_339 implements PerspectiveRenderable {
	
	private static final class_2960 SPINNER = class_2960.method_60655(OAuthAccountManagerReference.MODID, "textures/gui/spinner.png");
	
	private long lastTime;
	private int currentRotation;
	
	public LoadingSpinnerWidget(int x, int y, int width, int height) {
		super(x, y, width, height, class_5244.field_39003);
	}
	
	@Override
	public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		renderBehind(guiGraphics, mouseX, mouseY, partialTick);
		renderBefore(guiGraphics, mouseX, mouseY, partialTick);
	}
	
	@Override
	public void renderBehind(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		final class_4587 poseStack = guiGraphics.method_51448();
		
		poseStack.method_22903();
		
		poseStack.method_46416(method_46426(), method_46427(), 0);
		
		final float xRot = field_22758 / 2f;
		final float yRot = field_22759 / 2f;
		
		poseStack.method_46416(xRot, yRot, 0);
		poseStack.method_22907(class_7833.field_40718.rotationDegrees(currentRotation));
		poseStack.method_46416(-xRot, -yRot, 0);
		
		RenderUtil.drawTexturedQuad(poseStack, 0, 0 + field_22758, 0, 0 + field_22759, 0, 1, 0, 1, 0, SPINNER, RGBA.WHITE);
		
		poseStack.method_22909();
		
		if (class_156.method_658() - lastTime > 10) {
			lastTime = class_156.method_658();
			currentRotation += 2;
		}
	}
	
	@Override
	public void renderBefore(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
	}
	
	@Override
	protected void method_47399(class_6382 element) {
		method_37021(element);
	}
	
	@Override
	public void method_25354(class_1144 pHandler) {
		// Don't play click sound
	}
	
}
