package info.u_team.oauth_account_manager.screen.list;

import java.util.UUID;
import net.minecraft.class_437;
import org.apache.commons.lang3.StringUtils;

import info.u_team.oauth_account_manager.util.MinecraftAccounts;
import info.u_team.u_team_core.gui.elements.ScrollableList;

public class AccountSelectionList extends ScrollableList<AbstractAccountSelectionEntry> {
	
	private final class_437 ourScreen;
	
	public AccountSelectionList(class_437 ourScreen) {
		super(0, 0, 0, 0, 36, 0);
		this.ourScreen = ourScreen;
	}
	
	@Override
	public int method_25322() {
		return 305;
	}
	
	@Override
	protected int method_25329() {
		return field_22758 / 2 + 154;
	}
	
	public void loadEntries() {
		final UUID selectedUUID = method_25334() != null ? method_25334().getUuid() : null;
		method_25339();
		
		final LaunchedAccountSelectionEntry launchedEntry = new LaunchedAccountSelectionEntry(ourScreen, this);
		method_25321(launchedEntry);
		if (launchedEntry.getUuid().equals(selectedUUID)) {
			method_25313(launchedEntry);
		}
		
		MinecraftAccounts.getAccountUUIDs().stream().map(uuid -> new AccountSelectionEntry(ourScreen, this, uuid, MinecraftAccounts.getGameProfile(uuid))).sorted((a, b) -> {
			return StringUtils.compare(a.getProfile().getName(), b.getProfile().getName());
		}).forEach(entry -> {
			method_25321(entry);
			if (entry.getUuid().equals(selectedUUID)) {
				method_25313(entry);
			}
		});
		
		method_25307(method_25341());
	}
	
	public void useSelectedEntry() {
		final AbstractAccountSelectionEntry entry = method_25334();
		if (entry != null) {
			entry.useEntry();
		}
	}
	
	public void deleteSelectedEntry() {
		if (method_25334() instanceof AccountSelectionEntry entry) {
			method_25330(entry);
			MinecraftAccounts.removeAccount(entry.getUuid());
		}
	}
}
