package info.u_team.oauth_account_manager.screen;

import info.u_team.oauth_account_manager.init.OAuthAccountManagerLocalization;
import info.u_team.oauth_account_manager.util.AuthenticationUtil;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.screen.UScreen;
import net.hycrafthd.simple_minecraft_authenticator.method.AuthenticationMethod;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5489;
import net.minecraft.class_7843;
import net.minecraft.class_7849;

public class AddAccountOpenLinkScreen extends UScreen {
	
	private final class_437 lastScreen;
	
	private class_5489 message = class_5489.field_26528;
	
	public AddAccountOpenLinkScreen(class_437 lastScreen) {
		super(class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ADD_ACCOUNT_OPEN_LINK_TITLE));
		this.lastScreen = lastScreen;
	}
	
	@Override
	protected void method_25426() {
		super.method_25426();
		
		message = class_5489.method_30890(field_22793, class_2561.method_43469(OAuthAccountManagerLocalization.SCREEN_ADD_ACCOUNT_OPEN_LINK_MESSAGE, class_2561.method_43471("chat.link.open"), class_2561.method_43471("chat.copy")), field_22789 - 50);
		
		final UButton openLink = method_37063(new UButton(0, 0, 100, 20, class_2561.method_43471("chat.link.open")));
		openLink.setPressable(() -> startAuthenticationProcess(true));
		
		final UButton copyClipboard = method_37063(new UButton(0, 0, 100, 20, class_2561.method_43471("chat.copy")));
		copyClipboard.setPressable(() -> startAuthenticationProcess(false));
		
		final UButton cancelButton = method_37063(new UButton(0, 0, 100, 20, class_5244.field_24335));
		cancelButton.setPressable(() -> field_22787.method_1507(lastScreen));
		
		final class_7849 layout = new class_7849(308, 20, class_7849.class_7851.field_40789);
		layout.method_46495(openLink);
		layout.method_46495(copyClipboard);
		layout.method_46495(cancelButton);
		layout.method_48222();
		
		class_7843.method_46442(layout, 0, field_22790 - 64, field_22789, 64);
	}
	
	@Override
	public class_2561 method_25435() {
		return class_5244.method_37111(super.method_25435(), class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ADD_ACCOUNT_OPEN_LINK_MESSAGE));
	}
	
	@Override
	public void renderBefore(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		super.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
		
		guiGraphics.method_27534(field_22793, field_22785, field_22789 / 2, 20, 0xFFFFFF);
		message.method_30888(guiGraphics, field_22789 / 2, field_22790 / 2 - 40);
	}
	
	@Override
	public void method_25419() {
		field_22787.method_1507(lastScreen);
	}
	
	private void startAuthenticationProcess(boolean open) {
		final AuthenticationMethod method = AuthenticationUtil.createWebAuthenticationMethod();
		method.registerLoginUrlCallback(url -> {
			MinecraftExecutor.executeOnMainThread(() -> {
				if (open) {
					class_156.method_668().method_670(url.toString());
				} else {
					class_310.method_1551().field_1774.method_1455(url.toString());
				}
			});
		});
		
		final AddAccountOAuthScreen screen = new AddAccountOAuthScreen(lastScreen);
		screen.authenticate(method);
		field_22787.method_1507(screen);
	}
}