package info.u_team.oauth_account_manager.screen;

import info.u_team.oauth_account_manager.init.OAuthAccountManagerLocalization;
import info.u_team.oauth_account_manager.screen.list.AbstractAccountSelectionEntry;
import info.u_team.oauth_account_manager.screen.list.AccountSelectionEntry;
import info.u_team.oauth_account_manager.screen.list.AccountSelectionList;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.screen.UScreen;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7843;
import net.minecraft.class_7849;

public class AccountsScreen extends UScreen {
	
	private final class_437 lastScreen;
	
	private final AccountSelectionList list;
	
	private UButton useButton;
	private UButton deleteButton;
	
	public AccountsScreen(class_437 lastScreen) {
		super(class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ACCOUNTS_TITLE));
		this.lastScreen = lastScreen;
		list = new AccountSelectionList(this) {
			
			@Override
			public void setSelected(AbstractAccountSelectionEntry selected) {
				super.method_25313(selected);
				updateButtonState(selected);
			}
		};
	}
	
	@Override
	protected void method_25426() {
		super.method_25426();
		
		final UButton button = method_37063(MultiplayerScreenAdditions.addButton(field_22789, lastScreen));
		button.setPressable(() -> {
			method_25410(field_22787, field_22789, field_22790);
		});
		
		method_37063(list);
		list.method_55444(field_22789, field_22790 - 64 - 32, 0, 32);
		
		useButton = method_37063(new UButton(0, 0, 74, 20, class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ACCOUNTS_USE_BUTTON)));
		useButton.setPressable(list::useSelectedEntry);
		
		final UButton addButton = method_37063(new UButton(0, 0, 74, 20, class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ACCOUNTS_ADD_BUTTON)));
		addButton.setPressable(() -> {
			field_22787.method_1507(new AddAccountOpenLinkScreen(this));
		});
		
		deleteButton = method_37063(new UButton(0, 0, 74, 20, class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ACCOUNTS_DELETE_BUTTON)));
		deleteButton.setPressable(() -> {
			if (list.method_25334() instanceof AccountSelectionEntry entry) {
				field_22787.method_1507(new AccountDeleteScreen(this, entry.getProfile(), list::deleteSelectedEntry));
			}
		});
		
		final UButton cancelButton = method_37063(new UButton(0, 0, 74, 20, class_5244.field_24335));
		cancelButton.setPressable(() -> field_22787.method_1507(lastScreen));
		
		final class_7849 layout = new class_7849(308, 20, class_7849.class_7851.field_40789);
		layout.method_46495(useButton);
		layout.method_46495(addButton);
		layout.method_46495(deleteButton);
		layout.method_46495(cancelButton);
		layout.method_48222();
		
		class_7843.method_46442(layout, 0, field_22790 - 64, field_22789, 64);
		
		updateButtonState(null);
		
		list.loadEntries();
	}
	
	@Override
	public void renderBefore(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		super.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
		
		guiGraphics.method_27534(field_22793, field_22785, field_22789 / 2, 20, 0xFFFFFF);
	}
	
	@Override
	public void method_25419() {
		field_22787.method_1507(lastScreen);
	}
	
	public void updateButtonState(AbstractAccountSelectionEntry entry) {
		if (entry == null) {
			useButton.field_22763 = false;
			deleteButton.field_22763 = false;
		} else {
			useButton.field_22763 = true;
			deleteButton.field_22763 = entry instanceof AccountSelectionEntry;
		}
	}
	
}
