package info.u_team.oauth_account_manager.screen;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;

import com.mojang.authlib.GameProfile;
import com.mojang.util.UndashedUuid;

import info.u_team.oauth_account_manager.OAuthAccountManagerReference;
import info.u_team.oauth_account_manager.init.OAuthAccountManagerLocalization;
import info.u_team.oauth_account_manager.screen.widget.PlayerIconWidget;
import info.u_team.oauth_account_manager.util.LoadedAccount;
import info.u_team.oauth_account_manager.util.MinecraftAccounts;
import info.u_team.oauth_account_manager.util.MinecraftExecutor;
import net.hycrafthd.minecraft_authenticator.login.AuthenticationException;
import net.hycrafthd.minecraft_authenticator.login.Authenticator;
import net.hycrafthd.minecraft_authenticator.login.LoginState;
import net.hycrafthd.minecraft_authenticator.login.User;
import net.hycrafthd.minecraft_authenticator.login.XBoxProfile;
import net.hycrafthd.simple_minecraft_authenticator.SimpleMinecraftAuthentication;
import net.hycrafthd.simple_minecraft_authenticator.result.AuthenticationResult;
import net.hycrafthd.simple_minecraft_authenticator.util.AuthenticationFutureUtil;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public class AccountLoginScreen extends CommonWaitingScreen {
	
	private PlayerIconWidget playerIconWidget;
	
	public AccountLoginScreen(class_437 lastScreen) {
		super(lastScreen, lastScreen, class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_TITLE));
	}
	
	@Override
	protected void method_25426() {
		super.method_25426();
		setInformationMessage(getLoginStateComponent(LoginState.INITAL_FILE));
		spinnerWidget.method_47400(class_7919.method_47407(class_2561.method_43471(OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_SPINNER_TOOLTIP_LOGGING)));
		
		playerIconWidget = method_37063(new PlayerIconWidget(field_22789 / 2 - 32, field_22790 / 2 - 32, 64, null));
	}
	
	@Override
	protected void method_48640() {
		final GameProfile profile = playerIconWidget.getProfile();
		super.method_48640();
		playerIconWidget.setProfile(profile);
	}
	
	private class_2561 getLoginStateComponent(LoginState state) {
		return class_2561.method_43471(switch (state) {
		case INITAL_FILE -> OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_LOGIN_STATE_INFO_INITAL_FILE;
		case LOGIN_MICOSOFT -> OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_LOGIN_STATE_INFO_LOGIN_MICOSOFT;
		case XBL_TOKEN -> OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_LOGIN_STATE_INFO_XBL_TOKEN;
		case XSTS_TOKEN -> OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_LOGIN_STATE_INFO_XSTS_TOKEN;
		case ACCESS_TOKEN -> OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_LOGIN_STATE_INFO_ACCESS_TOKEN;
		case ENTITLEMENT -> OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_LOGIN_STATE_INFO_ENTITLEMENT;
		case PROFILE -> OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_LOGIN_STATE_INFO_PROFILE;
		case XBOX_PROFILE -> OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_LOGIN_STATE_INFO_XBOX_PROFILE;
		});
	}
	
	public void login(Optional<UUID> accountUUID, Supplier<AuthenticationResult> authenticationResult, Consumer<AccountLoginScreen> callback) {
		createWaitingThread(() -> {
			final Authenticator authenticator = authenticationResult.get().buildAuthenticator(true);
			try {
				AuthenticationFutureUtil.runAuthentication(SimpleMinecraftAuthentication.getExecutor(), () -> {
					// Run authentication to minecraft services
					authenticator.run(state -> {
						MinecraftExecutor.executeOnMainThread(() -> setInformationMessage(getLoginStateComponent(state)));
					});
					return null;
				}, 300, true);
			} catch (final AuthenticationException ex) {
				if (!(ex.getCause() instanceof InterruptedException)) {
					MinecraftExecutor.executeOnMainThread(() -> setFinalMessage(class_2561.method_43469(OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_INFORMATION_MESSAGE_ERROR, ex.getLocalizedMessage())));
					OAuthAccountManagerReference.LOGGER.warn("Authentication with minecraft services didn't complete sucessfully", ex);
				}
				
				// In error state update authentication file if uuid is known already
				accountUUID.ifPresent(uuid -> {
					if (authenticator.getResultFile() != null) {
						MinecraftAccounts.updateAuthenticationFile(uuid, authenticator.getResultFile());
					}
				});
				return;
			}
			
			final User user = authenticator.getUser().orElseThrow(AssertionError::new);
			final XBoxProfile xboxProfile = authenticator.getXBoxProfile().orElseThrow(AssertionError::new);
			
			// Parse uuid and validate
			final UUID uuid;
			try {
				uuid = UndashedUuid.fromStringLenient(user.uuid());
				
				if (accountUUID.isPresent()) {
					if (!accountUUID.get().equals(uuid)) {
						throw new IllegalArgumentException("UUID returned from minecraft services did not match existing uuid for that account");
					}
				}
			} catch (final IllegalArgumentException ex) {
				MinecraftExecutor.executeOnMainThread(() -> setFinalMessage(class_2561.method_43469(OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_INFORMATION_MESSAGE_ERROR, ex.getLocalizedMessage())));
				OAuthAccountManagerReference.LOGGER.error("Cannot add minecraft account", ex);
				return;
			}
			
			// Retrieve game profile
			final GameProfile profile = field_22787.method_1495().fetchProfile(uuid, true).profile();
			
			// Add account
			MinecraftAccounts.addAccount(uuid, authenticator.getResultFile(), profile, new LoadedAccount(user, xboxProfile));
			
			MinecraftExecutor.executeOnMainThread(() -> {
				playerIconWidget.setProfile(profile);
				setFinalMessage(class_2561.method_43469(OAuthAccountManagerLocalization.SCREEN_ACOUNT_LOGIN_INFORMATION_MESSAGE_SUCCESS, authenticator.getUser().get().name()));
				if (callback != null) {
					callback.accept(this);
				}
			});
		});
	}
}
