/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist.search;

import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchList;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryMusicTrack;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryPlaylist;
import info.u_team.music_player.gui.playlist.search.SearchProvider;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.UButton;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class GuiMusicSearch
extends BetterScreen {
    private final Playlist playlist;
    private EditBox urlField;
    private EditBox searchField;
    private final GuiMusicSearchList searchList;
    private SearchProvider searchProvider;
    private String information;
    private int informationTicks;
    private int maxTicksInformation;

    public GuiMusicSearch(Playlist playlist) {
        super((Component)Component.literal((String)"musicsearch"));
        this.playlist = playlist;
        this.searchList = new GuiMusicSearchList();
        this.searchProvider = SearchProvider.YOUTUBE;
    }

    protected void init() {
        ImageButton backButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK));
        backButton.setPressable(() -> this.minecraft.setScreen((Screen)new GuiMusicPlaylist(this.playlist)));
        this.urlField = new EditBox(this.font, 10, 35, this.width / 2 - 10, 20, Component.nullToEmpty((String)"")){

            public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, this.getValue(), key);
                return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
            }
        };
        this.urlField.setMaxLength(10000);
        this.addWidget((GuiEventListener)this.urlField);
        String lang = Minecraft.getInstance().getLanguageManager().getSelected();
        UButton openFileButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(this.width / 2 + 10, 34, this.width / 4 - 15, 22, Component.nullToEmpty((String)MusicPlayerLocalization.getTranslation("gui.search.load.file", new Object[0]))));
        openFileButton.setPressable(() -> {
            String response = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)GuiMusicSearch.getSearchLoadFileTitle(lang), null, null, (CharSequence)GuiMusicSearch.getSearchLoadFiles(lang), (boolean)false);
            if (response != null) {
                this.searchList.clear();
                this.addTrack(response);
            }
        });
        UButton openFolderButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton((int)((double)this.width * 0.75) + 5, 34, this.width / 4 - 15, 22, Component.nullToEmpty((String)MusicPlayerLocalization.getTranslation("gui.search.load.folder", new Object[0]))));
        openFolderButton.setPressable(() -> {
            String response = TinyFileDialogs.tinyfd_selectFolderDialog((CharSequence)GuiMusicSearch.getSearchLoadFolderTitle(lang), (CharSequence)System.getProperty("user.home"));
            if (response != null) {
                this.searchList.clear();
                try (Stream<Path> stream = Files.list(Paths.get(response, new String[0]));){
                    stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> this.addTrack(path.toString()));
                }
                catch (IOException ex) {
                    this.setInformation(String.valueOf(ChatFormatting.RED) + ex.getMessage(), 150);
                }
            }
        });
        ImageButton searchButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(10, 76, 24, 24, this.searchProvider.getLogo()));
        searchButton.setPressable(() -> {
            this.searchProvider = SearchProvider.toggle(this.searchProvider);
            searchButton.setImage(this.searchProvider.getLogo());
        });
        this.searchField = new EditBox(this.font, 40, 78, this.width - 51, 20, Component.nullToEmpty((String)"")){

            public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, GuiMusicSearch.this.searchProvider.getPrefix() + this.getValue(), key);
                return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
            }
        };
        this.searchField.setMaxLength(1000);
        this.setFocused((GuiEventListener)this.searchField);
        this.addWidget((GuiEventListener)this.searchField);
        UButton addAllButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(this.width - 110, 105, 100, 20, Component.nullToEmpty((String)MusicPlayerLocalization.getTranslation("gui.search.add_all", new Object[0]))));
        addAllButton.setPressable(() -> {
            List<GuiMusicSearchListEntryPlaylist> list = this.searchList.children().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryPlaylist).map(entry -> (GuiMusicSearchListEntryPlaylist)((Object)((Object)entry))).collect(Collectors.toList());
            if (list.size() > 0) {
                list.forEach(entry -> this.playlist.add(entry.getTrackList()));
            } else {
                this.searchList.children().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryMusicTrack).map(entry -> (GuiMusicSearchListEntryMusicTrack)((Object)((Object)entry))).filter(entry -> !entry.isPlaylistEntry()).forEach(entry -> this.playlist.add(entry.getTrack()));
            }
            this.setInformation(String.valueOf(ChatFormatting.GREEN) + MusicPlayerLocalization.getTranslation("gui.search.added_all", new Object[0]), 150);
        });
        this.searchList.updateSettings(12, 130, this.width - 24, this.height - 140);
        this.addWidget((GuiEventListener)this.searchList);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String urlFieldText = this.urlField.getValue();
        boolean urlFieldFocus = this.urlField.isFocused() && this.getFocused() == this.urlField;
        String searchFieldText = this.searchField.getValue();
        boolean searchFieldFocus = this.searchField.isFocused() && this.getFocused() == this.searchField;
        this.init(minecraft, width, height);
        this.urlField.setValue(urlFieldText);
        this.urlField.setFocused(urlFieldFocus);
        if (urlFieldFocus) {
            this.setFocused((GuiEventListener)this.urlField);
        }
        this.searchField.setValue(searchFieldText);
        this.searchField.setFocused(searchFieldFocus);
        if (searchFieldFocus) {
            this.setFocused((GuiEventListener)this.searchField);
        }
    }

    public void tick() {
        ++this.informationTicks;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.searchList.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.minecraft.font, MusicPlayerLocalization.getTranslation("gui.search.header", new Object[0]), this.width / 2, 5, 0xFFFFFF);
        guiGraphics.drawString(this.minecraft.font, MusicPlayerLocalization.getTranslation("gui.search.search.uri", new Object[0]), 10, 20, 0xFFFFFF);
        guiGraphics.drawString(this.minecraft.font, MusicPlayerLocalization.getTranslation("gui.search.search.file", new Object[0]), 10 + this.width / 2, 20, 0xFFFFFF);
        guiGraphics.drawString(this.minecraft.font, MusicPlayerLocalization.getTranslation("gui.search.search.search", new Object[0]), 10, 63, 0xFFFFFF);
        if (this.information != null && this.informationTicks <= this.maxTicksInformation) {
            guiGraphics.drawString(this.minecraft.font, this.information, 15, 110, 0xFFFFFF);
        }
        this.urlField.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.searchField.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.urlField.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.urlField);
            this.urlField.setFocused(true);
            this.searchField.setFocused(false);
            return true;
        }
        if (this.searchField.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.searchField);
            this.searchField.setFocused(true);
            this.urlField.setFocused(false);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void setInformation(String information, int maxTicksInformation) {
        this.information = information;
        this.maxTicksInformation = maxTicksInformation;
        this.informationTicks = 0;
    }

    private void keyFromTextField(EditBox field, String text, int key) {
        if (field.isVisible() && field.isFocused() && (key == 257 || key == 335)) {
            this.searchList.clear();
            this.addTrack(text);
            field.setValue("");
        }
    }

    private void addTrack(String uri) {
        MusicPlayerManager.getPlayer().getTrackSearch().getTracks(uri, result -> this.minecraft.execute(() -> {
            if (result.hasError()) {
                this.setInformation(String.valueOf(ChatFormatting.RED) + result.getErrorMessage(), 150);
            } else if (result.isList()) {
                IAudioTrackList list = result.getTrackList();
                if (!list.isSearch()) {
                    this.searchList.add(new GuiMusicSearchListEntryPlaylist(this, this.playlist, list));
                }
                list.getTracks().forEach(track -> this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, (IAudioTrack)track, !list.isSearch())));
            } else {
                IAudioTrack track2 = result.getTrack();
                this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, track2, false));
            }
        }));
    }

    private static String getSearchLoadFileTitle(String lang) {
        return switch (lang) {
            case "jp_jp" -> "\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u3080";
            case "ko_kr" -> "\ud30c\uc77c \ubd88\ub7ec\uc624\uae30";
            case "pt_br" -> "Subir arquivo";
            case "ru_ru" -> "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b";
            case "zn_cn" -> "\u52a0\u8f7d\u6587\u4ef6";
            case "zn_tw" -> "\u8f09\u5165\u6a94\u6848";
            case "de_de" -> "Lade eine Datei";
            default -> "Load file";
        };
    }

    private static String getSearchLoadFiles(String lang) {
        return switch (lang) {
            case "jp_jp" -> "\u30df\u30e5\u30fc\u30b8\u30c3\u30af\u30d5\u30a1\u30a4\u30eb";
            case "ko_kr" -> "\uc74c\uc545 \ud30c\uc77c";
            case "pt_br" -> "arquivos de m\u00fasica";
            case "ru_ru" -> "\u0424\u0430\u0439\u043b\u044b \u0441 \u043c\u0443\u0437\u044b\u043a\u043e\u0439";
            case "zn_cn" -> "\u97f3\u4e50\u6587\u4ef6";
            case "zn_tw" -> "\u97f3\u6a02\u6a94\u6848";
            case "de_de" -> "Musikdatein";
            default -> "Music files";
        };
    }

    private static String getSearchLoadFolderTitle(String lang) {
        return switch (lang) {
            case "jp_jp" -> "\u30d5\u30a9\u30eb\u30c0\u3092\u8aad\u307f\u8fbc\u3080";
            case "ko_kr" -> "\ud3f4\ub354 \ubd88\ub7ec\uc624\uae30";
            case "pt_br" -> "Pasta de download";
            case "ru_ru" -> "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0430\u043f\u043a\u0443";
            case "zn_cn" -> "\u52a0\u8f7d\u6587\u4ef6\u5939";
            case "zn_tw" -> "\u8f09\u5165\u8cc7\u6599\u593e";
            case "de_de" -> "Lade einen Ordner";
            default -> "Load folder";
        };
    }
}

