/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist;

import info.u_team.music_player.gui.playlist.GuiMusicPlaylistList;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryFunctions;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryPlaylistTrack;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.music_player.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;

public class GuiMusicPlaylistListEntryPlaylistStart
extends GuiMusicPlaylistListEntryFunctions {
    private final String name;
    private final String duration;
    private final List<GuiMusicPlaylistListEntryPlaylistTrack> entries;

    public GuiMusicPlaylistListEntryPlaylistStart(GuiMusicPlaylistList guilist, Playlists playlists, Playlist playlist, LoadedTracks loadedTracks) {
        super(guilist, playlists, playlist, loadedTracks, loadedTracks.getFirstTrack());
        this.name = loadedTracks.getTitle();
        List<IAudioTrack> tracks = loadedTracks.getTrackList().getTracks();
        this.duration = !tracks.parallelStream().anyMatch(track -> track.getInfo().isStream()) ? TimeUtil.timeConversion(tracks.parallelStream().mapToLong(track -> track.getDuration()).sum() / 1000L) : MusicPlayerLocalization.getTranslation("gui.track.duration_undefined", new Object[0]);
        this.entries = new ArrayList<GuiMusicPlaylistListEntryPlaylistTrack>();
    }

    @Override
    public void drawEntryExtended(GuiGraphics guiGraphics, int entryX, int entryY, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean mouseInList, float partialTicks) {
        guiGraphics.drawString(this.minecraft.font, this.name, entryX + 5, entryY + 15, 16048706, false);
        guiGraphics.drawString(this.minecraft.font, this.duration, entryX + entryWidth - 140, entryY + 15, 0xFFFF00, false);
    }

    public void addEntry(GuiMusicPlaylistListEntryPlaylistTrack entry) {
        this.entries.add(entry);
    }

    @Override
    protected boolean isPlaying() {
        return this.entries.stream().anyMatch(entry -> entry.getStart() == this && entry.getTrack() == this.getCurrentlyPlaying());
    }
}

