/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.dependency;

import com.google.common.base.Predicates;
import info.u_team.music_player.dependency.classloader.DependencyClassLoader;
import info.u_team.u_team_core.util.ServiceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.StringUtil;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class DependencyManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER_LOAD = MarkerManager.getMarker((String)"Load");
    private static final Marker MARKER_ADD = MarkerManager.getMarker((String)"Add");
    private static final String FILE_ENDING = ".jar.packed";
    private static final PathLocator PATH_LOCATOR = (PathLocator)ServiceUtil.loadOne(PathLocator.class);
    public static final DependencyClassLoader MUSICPLAYER_CLASSLOADER = new DependencyClassLoader();

    public static void load() {
        LOGGER.info(MARKER_LOAD, "Load dependencies");
        Path tmpPath = DependencyManager.createExtractDirectory();
        LOGGER.info(MARKER_LOAD, "Extraction directory for jar files is {} ", (Object)tmpPath.toAbsolutePath());
        String devPath = System.getProperty("musicplayer.dev");
        Set<Path> paths = devPath != null ? Stream.of(devPath.split(";")).filter((Predicate<String>)Predicates.not(StringUtil::isNullOrEmpty)).map(x$0 -> Paths.get(x$0, new String[0])).map(DependencyManager::findJarFilesInDev).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet()) : DependencyManager.findJarFilesInJar("dependencies");
        paths.stream().map(path -> DependencyManager.extractFile(tmpPath, path)).map(DependencyManager::pathToUrl).forEach(DependencyManager::addToMusicPlayerDependencies);
        LOGGER.info(MARKER_LOAD, "Finished loading dependencies");
    }

    private static Path createExtractDirectory() {
        try {
            Path baseDirectory = Paths.get(System.getProperty("java.io.tmpdir", "/tmp"), "musicplayer-extraction-tmp");
            Path specificDirectory = baseDirectory.resolve(String.valueOf(System.currentTimeMillis()));
            try {
                FileUtils.deleteDirectory((File)baseDirectory.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Files.createDirectories(specificDirectory, new FileAttribute[0]);
            return specificDirectory;
        }
        catch (IOException unused) {
            try {
                return Files.createTempDirectory("musicplayer-extraction-tmp", new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot create extract directory for musicplayer files", ex);
            }
        }
    }

    private static Path extractFile(Path extractDirectory, Path path) {
        Path extractPath = extractDirectory.resolve(path.getFileName().toString());
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
             OutputStream outputStream = Files.newOutputStream(extractPath, StandardOpenOption.CREATE);){
            inputStream.transferTo(outputStream);
            LOGGER.debug(MARKER_LOAD, "Copied file from ({}) to ({})", (Object)path, (Object)extractPath);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot extract file " + String.valueOf(path) + " to " + String.valueOf(extractPath), ex);
        }
        return extractPath;
    }

    private static URL pathToUrl(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Set<Path> findJarFilesInDev(Path path) {
        Set<Path> set;
        block8: {
            Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
            try {
                set = DependencyManager.filterPackedFiles(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOGGER.error(MARKER_LOAD, "When searching for jar files in dev an exception occured.", (Throwable)ex);
                    return Collections.emptySet();
                }
            }
            stream.close();
        }
        return set;
    }

    private static Set<Path> findJarFilesInJar(String folder) {
        Set<Path> set;
        block8: {
            Stream<Path> stream = Files.walk(PATH_LOCATOR.locate("musicplayer", folder), new FileVisitOption[0]);
            try {
                set = DependencyManager.filterPackedFiles(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | IllegalStateException ex) {
                    LOGGER.error(MARKER_LOAD, "When searching for jar files in jar an exception occured.", (Throwable)ex);
                    return Collections.emptySet();
                }
            }
            stream.close();
        }
        return set;
    }

    private static Set<Path> filterPackedFiles(Stream<Path> stream) {
        return stream.filter(file -> file.toString().endsWith(FILE_ENDING)).collect(Collectors.toSet());
    }

    private static void addToMusicPlayerDependencies(URL url) {
        MUSICPLAYER_CLASSLOADER.addURL(url);
        LOGGER.debug(MARKER_ADD, "Added new jar file ({}) to the musicplayer dependency classloader.", (Object)url);
    }

    public static interface PathLocator {
        public Path locate(String var1, String var2) throws IOException, IllegalStateException;
    }
}

