/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.musicplayer.playlist;

import com.google.common.collect.Iterators;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Playlists
implements Iterable<Playlist> {
    private final List<Playlist> playlists = new ArrayList<Playlist>();
    private transient boolean locked;
    private transient Playlist playing;

    public int size() {
        return this.playlists.size();
    }

    public Playlist get(int index) {
        return this.playlists.get(index);
    }

    public void add(Playlist playlist) {
        this.playlists.add(playlist);
        this.save();
    }

    public void remove(Playlist playlist) {
        this.playlists.remove(playlist);
        this.save();
    }

    public void setPlayingLock() {
        this.locked = true;
    }

    public void removePlayingLock() {
        this.locked = false;
    }

    public boolean isPlayingLock() {
        return this.locked;
    }

    public void setPlaying(Playlist playing) {
        this.playing = playing;
    }

    public Playlist getPlaying() {
        return this.playing;
    }

    @Override
    public Iterator<Playlist> iterator() {
        return Iterators.unmodifiableIterator(this.playlists.iterator());
    }

    private void save() {
        MusicPlayerManager.getPlaylistManager().writeToFile();
    }
}

