/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.util;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackInfo;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.util.TimeUtil;
import java.net.URI;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public final class GuiTrackUtils {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();

    public static String trimToWith(String string, int width) {
        Object newString = GuiTrackUtils.MINECRAFT.f_91062_.m_92834_(string, width);
        if (!((String)newString).equals(string)) {
            newString = (String)newString + "...";
        }
        return newString;
    }

    public static void addTrackInfo(PoseStack matrixStack, IAudioTrack track, int x, int y, int entryWidth, int leftMargin, int titleColor) {
        int textSize = entryWidth - 150 - leftMargin;
        IAudioTrackInfo info = track.getInfo();
        String title = GuiTrackUtils.trimToWith(info.getFixedTitle(), textSize);
        String author = GuiTrackUtils.trimToWith(info.getFixedAuthor(), textSize);
        String duration = GuiTrackUtils.getFormattedDuration(track);
        GuiTrackUtils.MINECRAFT.f_91062_.m_92883_(matrixStack, title, (float)(x + leftMargin), (float)(y + 5), titleColor);
        GuiTrackUtils.MINECRAFT.f_91062_.m_92883_(matrixStack, author, (float)(x + leftMargin + 4), (float)(y + 25), 14183708);
        GuiTrackUtils.MINECRAFT.f_91062_.m_92883_(matrixStack, duration, (float)(x + entryWidth - 140), (float)(y + 15), 0xFFFF00);
    }

    public static boolean openURI(String uri) {
        Style style = Component.m_130674_(null).m_7383_();
        try {
            new URI(uri);
            style = style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, uri));
        }
        catch (Exception ex) {
            style = style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, uri));
        }
        return GuiTrackUtils.MINECRAFT.f_91080_.m_5561_(style);
    }

    public static String getFormattedDuration(IAudioTrack track) {
        long seconds;
        if (track == null) {
            seconds = 0L;
        } else {
            IAudioTrackInfo info = track.getInfo();
            if (info.isStream()) {
                return MusicPlayerLocalization.getTranslation("gui.track.duration_undefined", new Object[0]);
            }
            seconds = track.getDuration() / 1000L;
        }
        return TimeUtil.timeConversion(seconds);
    }

    public static String getFormattedPosition(IAudioTrack track) {
        return TimeUtil.timeConversion(track == null ? 0L : track.getPosition() / 1000L);
    }

    public static <T> T getValueOfPlayingTrack(Function<IAudioTrack, T> function) {
        return GuiTrackUtils.getValueOfNullableTrack(MusicPlayerManager.getPlayer().getTrackManager().getCurrentTrack(), function);
    }

    public static <T> T getValueOfNullableTrack(IAudioTrack track, Function<IAudioTrack, T> function) {
        if (track != null) {
            return function.apply(track);
        }
        return null;
    }
}

