/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerColors;
import info.u_team.music_player.lavaplayer.api.audio.IPlayingTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.u_team_core.gui.renderer.ScalingTextRenderer;
import info.u_team.u_team_core.gui.renderer.ScrollingTextRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IRenderable;

public class RenderOverlayMusicDisplay
implements IRenderable {
    private final ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
    private final int width;
    private final int height;
    private final ScrollingTextRenderer title;
    private final ScrollingTextRenderer author;
    private final ScalingTextRenderer position;
    private final ScalingTextRenderer duration;

    public RenderOverlayMusicDisplay() {
        this.height = 35;
        this.width = 120;
        FontRenderer fontRender = Minecraft.func_71410_x().field_71466_p;
        this.title = new ScrollingTextRenderer(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedTitle()), 3.0f, 2.0f);
        this.title.setStepSize(0.5f);
        this.title.setColor(MusicPlayerColors.YELLOW);
        this.title.setWidth(114);
        this.title.setSpeedTime(35);
        this.author = new ScrollingTextRenderer(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedAuthor()), 3.0f, 12.0f);
        this.author.setStepSize(0.5f);
        this.author.setColor(MusicPlayerColors.YELLOW);
        this.author.setScale(0.75f);
        this.author.setWidth(114);
        this.author.setSpeedTime(35);
        this.position = new ScalingTextRenderer(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(GuiTrackUtils::getFormattedPosition), 6.0f, 28.0f);
        this.position.setColor(MusicPlayerColors.YELLOW);
        this.position.setScale(0.5f);
        this.duration = new ScalingTextRenderer(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(GuiTrackUtils::getFormattedDuration), (float)(this.width - 6), 28.0f);
        this.duration.setTextChanged(renderer -> this.duration.setX((float)(this.width - 6) - renderer.getTextWidth()));
        this.duration.setColor(MusicPlayerColors.YELLOW);
        this.duration.setScale(0.5f);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        IPlayingTrack track = this.manager.getCurrentTrack();
        if (track == null) {
            return;
        }
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)this.width, (int)this.height, (int)-14606047);
        double progress = track.getInfo().isStream() ? 0.5 : (double)track.getPosition() / (double)track.getDuration();
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)6, (int)23, (int)(this.width - 6), (int)26, (int)-11184811);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)6, (int)23, (int)(6 + (int)((double)(this.width - 12) * progress)), (int)26, (int)-12676864);
        this.title.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.author.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.position.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.duration.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

