/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.musicplayer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import info.u_team.music_player.dependency.DependencyManager;
import info.u_team.music_player.lavaplayer.api.IMusicPlayer;
import info.u_team.music_player.musicplayer.PlaylistManager;
import info.u_team.music_player.musicplayer.SettingsManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MusicPlayerManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static IMusicPlayer PLAYER;
    private static final Gson GSON;
    private static final PlaylistManager PLAYLIST_MANAGER;
    private static final SettingsManager SETTINGS_MANAGER;

    public static void setup() {
        MusicPlayerManager.generatePlayer();
        PLAYER.startAudioOutput();
        PLAYLIST_MANAGER.loadFromFile();
        SETTINGS_MANAGER.loadFromFile();
        PLAYER.setVolume(SETTINGS_MANAGER.getSettings().getVolume());
    }

    private static void generatePlayer() {
        try {
            Class<?> clazz = Class.forName("info.u_team.music_player.lavaplayer.MusicPlayer", true, DependencyManager.MUSICPLAYER_CLASSLOADER);
            if (!IMusicPlayer.class.isAssignableFrom(clazz)) {
                throw new IllegalAccessError("The class " + clazz + " does not implement IMusicPlayer! This should not happen?!");
            }
            PLAYER = (IMusicPlayer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LOGGER.info("Successfully created music player instance");
        }
        catch (Exception ex) {
            LOGGER.fatal("Cannot create music player instance. This is a serious bug and the mod will not work. Report to the mod authors", (Throwable)ex);
            System.exit(-1);
        }
    }

    public static IMusicPlayer getPlayer() {
        return PLAYER;
    }

    public static PlaylistManager getPlaylistManager() {
        return PLAYLIST_MANAGER;
    }

    public static SettingsManager getSettingsManager() {
        return SETTINGS_MANAGER;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        PLAYLIST_MANAGER = new PlaylistManager(GSON);
        SETTINGS_MANAGER = new SettingsManager(GSON);
    }
}

