/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.init;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.init.MusicPlayerKeys;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.MusicPlayerUtils;
import info.u_team.music_player.musicplayer.SettingsManager;
import info.u_team.music_player.musicplayer.settings.IngameOverlayPosition;
import info.u_team.music_player.render.RenderOverlayMusicDisplay;
import info.u_team.u_team_core.gui.renderer.ScrollingTextRenderer;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class MusicPlayerEventHandler {
    private static final SettingsManager SETTINGS_MANAGER = MusicPlayerManager.getSettingsManager();
    private static RenderOverlayMusicDisplay overlayRender;
    private static ScrollingTextRenderer titleRender;
    private static ScrollingTextRenderer authorRender;

    private static void onKeyInput(InputEvent.KeyInputEvent event) {
        MusicPlayerEventHandler.handleKeyboard(false, -1, -1);
    }

    private static void onKeyboardPressed(GuiScreenEvent.KeyboardKeyPressedEvent.Post event) {
        if (SETTINGS_MANAGER.getSettings().isKeyWorkInGui()) {
            event.setCanceled(MusicPlayerEventHandler.handleKeyboard(true, event.getKeyCode(), event.getScanCode()));
        }
    }

    private static boolean handleKeyboard(boolean gui, int keyCode, int scanCode) {
        boolean handled;
        ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
        if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.OPEN, gui, keyCode, scanCode)) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!(mc.field_71462_r instanceof GuiMusicPlayer)) {
                mc.func_147108_a((Screen)new GuiMusicPlayer());
            }
            handled = true;
        } else if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.PAUSE, gui, keyCode, scanCode)) {
            if (manager.getCurrentTrack() != null) {
                manager.setPaused(!manager.isPaused());
            }
            handled = true;
        } else if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.SKIP_FORWARD, gui, keyCode, scanCode)) {
            if (manager.getCurrentTrack() != null) {
                MusicPlayerUtils.skipForward();
            }
            handled = true;
        } else if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.SKIP_BACK, gui, keyCode, scanCode)) {
            if (manager.getCurrentTrack() != null) {
                MusicPlayerUtils.skipBack();
            }
            handled = true;
        } else {
            handled = false;
        }
        return handled;
    }

    private static boolean isKeyDown(KeyBinding binding, boolean gui, int keyCode, int scanCode) {
        if (gui) {
            return binding.isActiveAndMatches(InputMappings.func_197954_a((int)keyCode, (int)scanCode));
        }
        return binding.func_151468_f();
    }

    private static void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && SETTINGS_MANAGER.getSettings().isShowIngameOverlay()) {
            IngameOverlayPosition position = SETTINGS_MANAGER.getSettings().getIngameOverlayPosition();
            if (overlayRender == null) {
                overlayRender = new RenderOverlayMusicDisplay();
            }
            MainWindow window = mc.func_228018_at_();
            int screenWidth = window.func_198107_o();
            int screenHeight = window.func_198087_p();
            int height = overlayRender.getHeight();
            int width = overlayRender.getWidth();
            int x = position.isLeft() ? 3 : screenWidth - 3 - width;
            int y = position.isUp() ? 3 : screenHeight - 3 - height;
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)x, (double)y, 500.0);
            overlayRender.func_230430_a_(matrixStack, 0, 0, event.getPartialTicks());
            matrixStack.func_227865_b_();
        }
    }

    private static void onInitGuiPre(GuiScreenEvent.InitGuiEvent.Pre event) {
        Screen gui = event.getGui();
        if (gui instanceof IngameMenuScreen && SETTINGS_MANAGER.getSettings().isShowIngameMenueOverlay()) {
            gui.func_231039_at__().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> {
                titleRender = controls.getTitleRender();
                authorRender = controls.getAuthorRender();
            });
        }
    }

    private static void onInitGuiPost(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen gui = event.getGui();
        if (gui instanceof IngameMenuScreen && SETTINGS_MANAGER.getSettings().isShowIngameMenueOverlay()) {
            GuiControls controls = new GuiControls(gui, 3, gui.field_230708_k_);
            if (titleRender != null) {
                controls.copyTitleRendererState(titleRender);
                titleRender = null;
            }
            if (authorRender != null) {
                controls.copyAuthorRendererState(authorRender);
                authorRender = null;
            }
            List list = gui.func_231039_at__();
            list.add(controls);
        }
    }

    private static void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        Screen gui = event.getGui();
        if (gui instanceof IngameMenuScreen && SETTINGS_MANAGER.getSettings().isShowIngameMenueOverlay()) {
            gui.func_231039_at__().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> controls.func_230430_a_(event.getMatrixStack(), event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks()));
        }
    }

    private static void onMouseReleasePre(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        Screen gui = event.getGui();
        if (gui instanceof IngameMenuScreen && SETTINGS_MANAGER.getSettings().isShowIngameMenueOverlay()) {
            gui.func_231039_at__().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> controls.func_231048_c_(event.getMouseX(), event.getMouseY(), event.getButton()));
        }
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        Screen gui;
        if (event.phase == TickEvent.Phase.END && (gui = Minecraft.func_71410_x().field_71462_r) instanceof IngameMenuScreen && SETTINGS_MANAGER.getSettings().isShowIngameMenueOverlay()) {
            gui.func_231039_at__().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(GuiControls::tick);
        }
    }

    public static void registerForge(IEventBus bus) {
        bus.addListener(MusicPlayerEventHandler::onKeyInput);
        bus.addListener(MusicPlayerEventHandler::onKeyboardPressed);
        bus.addListener(MusicPlayerEventHandler::onRenderGameOverlay);
        bus.addListener(MusicPlayerEventHandler::onInitGuiPre);
        bus.addListener(MusicPlayerEventHandler::onInitGuiPost);
        bus.addListener(MusicPlayerEventHandler::onDrawScreenPost);
        bus.addListener(MusicPlayerEventHandler::onMouseReleasePre);
        bus.addListener(MusicPlayerEventHandler::onClientTick);
    }
}

