/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.music_player.gui.BetterNestedGui;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiMusicProgressBar;
import info.u_team.music_player.gui.controls.GuiVolumeSlider;
import info.u_team.music_player.gui.settings.GuiMusicPlayerSettings;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerColors;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.MusicPlayerUtils;
import info.u_team.music_player.musicplayer.settings.Repeat;
import info.u_team.music_player.musicplayer.settings.Settings;
import info.u_team.u_team_core.gui.elements.ImageActivatableButton;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ImageToggleButton;
import info.u_team.u_team_core.gui.renderer.ScrollingTextRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;

public class GuiControls
extends FocusableGui
implements BetterNestedGui,
IRenderable {
    private final int middleX;
    private final int y;
    private final int width;
    private final int buttonSize;
    private final int halfButtonSize;
    private final List<Widget> buttons;
    private final List<Widget> disableButtons;
    private final List<IGuiEventListener> children;
    private final ITrackManager manager;
    private final ImageToggleButton playButton;
    private final GuiMusicProgressBar songProgress;
    private final ScrollingTextRenderer titleRender;
    private final ScrollingTextRenderer authorRender;

    public GuiControls(Screen gui, int y, int width) {
        boolean isIngame;
        this.y = y;
        this.width = width;
        this.middleX = width / 2;
        this.buttons = new ArrayList<Widget>();
        this.disableButtons = new ArrayList<Widget>();
        this.children = new ArrayList<IGuiEventListener>();
        this.manager = MusicPlayerManager.getPlayer().getTrackManager();
        Minecraft mc = Minecraft.func_71410_x();
        boolean isSettings = gui instanceof GuiMusicPlayerSettings;
        boolean small = isIngame = gui instanceof IngameMenuScreen;
        this.buttonSize = small ? 15 : 20;
        this.halfButtonSize = this.buttonSize / 2;
        this.playButton = this.addButton(new ImageToggleButton(this.middleX - this.halfButtonSize, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_PLAY, MusicPlayerResources.TEXTURE_PAUSE, !this.manager.isPaused()));
        this.playButton.setPressable(() -> {
            boolean play = this.playButton.isToggled();
            this.manager.setPaused(!play);
        });
        ImageButton skipForwardButton = this.addButton(new ImageButton(this.middleX + this.halfButtonSize + 5, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SKIP_FORWARD));
        skipForwardButton.setPressable(() -> MusicPlayerUtils.skipForward());
        ImageButton skipBackButton = this.addButton(new ImageButton(this.middleX - (this.buttonSize + this.halfButtonSize + 5), y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SKIP_BACK));
        skipBackButton.setPressable(() -> MusicPlayerUtils.skipBack());
        Settings settings = MusicPlayerManager.getSettingsManager().getSettings();
        ImageActivatableButton shuffleButton = this.addButton(new ImageActivatableButton(this.middleX - (2 * this.buttonSize + this.halfButtonSize + 10), y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SHUFFLE, settings.isShuffle(), MusicPlayerColors.LIGHT_GREEN));
        shuffleButton.setPressable(() -> {
            settings.setShuffle(!settings.isShuffle());
            shuffleButton.setActivated(settings.isShuffle());
        });
        ImageActivatableButton repeatButton = this.addButton(new ImageActivatableButton(this.middleX + this.buttonSize + this.halfButtonSize + 10, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_REPEAT, settings.getRepeat().isActive(), MusicPlayerColors.LIGHT_GREEN));
        repeatButton.setImage(settings.getRepeat().getResource());
        repeatButton.setPressable(() -> {
            settings.setRepeat(Repeat.forwardCycle(settings.getRepeat()));
            repeatButton.setActivated(settings.getRepeat().isActive());
            repeatButton.setImage(settings.getRepeat().getResource());
        });
        this.songProgress = new GuiMusicProgressBar(this.manager, this.middleX - (small ? 50 : 100), y + (small ? 20 : 30), small ? 100 : 200, small ? 3 : 5, small ? 0.5f : 1.0f);
        this.children.add((IGuiEventListener)this.songProgress);
        if (!isSettings) {
            ImageButton settingsButton = this.addButtonNonDisable(new ImageButton(width - 16, 1, 15, 15, MusicPlayerResources.TEXTURE_SETTINGS));
            settingsButton.setPressable(() -> mc.func_147108_a((Screen)new GuiMusicPlayerSettings(gui)));
        }
        if (isIngame) {
            ImageButton guiButton = this.addButtonNonDisable(new ImageButton(width - 32, 1, 15, 15, MusicPlayerResources.TEXTURE_OPEN));
            guiButton.setPressable(() -> mc.func_147108_a((Screen)new GuiMusicPlayer()));
        }
        int volumeY = width - (70 + (isIngame ? 33 : (!isSettings ? 17 : 1)));
        this.addButtonNonDisable(new GuiVolumeSlider(volumeY, 1, 70, 15, ITextComponent.func_244388_a((String)(MusicPlayerLocalization.getTranslation("gui.controls.volume", new Object[0]) + ": ")), ITextComponent.func_244388_a((String)"%"), 0.0, 100.0, settings.getVolume(), false, true, false, 0.7f, slider -> {
            settings.setVolume(slider.getValueInt());
            MusicPlayerManager.getPlayer().setVolume(settings.getVolume());
        }));
        int textRenderWidth = this.middleX - (2 * this.buttonSize + this.halfButtonSize + 10) - (small ? 15 : 35);
        int textRenderY = small ? y : y + 2;
        this.titleRender = new ScrollingTextRenderer(mc.field_71466_p, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedTitle()), small ? 10.0f : 25.0f, (float)textRenderY);
        this.titleRender.setWidth(textRenderWidth);
        this.titleRender.setStepSize(0.5f);
        this.titleRender.setColor(MusicPlayerColors.YELLOW);
        this.titleRender.setSpeedTime(35);
        this.authorRender = new ScrollingTextRenderer(mc.field_71466_p, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedAuthor()), small ? 10.0f : 25.0f, (float)(textRenderY + 10));
        this.authorRender.setWidth(textRenderWidth);
        this.authorRender.setStepSize(0.5f);
        this.authorRender.setColor(MusicPlayerColors.YELLOW);
        this.authorRender.setScale(0.75f);
        this.authorRender.setSpeedTime(35);
        this.disableButtons.forEach(button -> {
            button.field_230693_o_ = false;
        });
        this.buttons.forEach(this.children::add);
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return true;
    }

    public void tick() {
        if (this.manager.getCurrentTrack() == null) {
            this.disableButtons.forEach(button -> {
                button.field_230693_o_ = false;
            });
        } else {
            this.disableButtons.forEach(button -> {
                button.field_230693_o_ = true;
            });
        }
        this.playButton.setToggled(!this.manager.isPaused());
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.children;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.buttons.forEach(button -> button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks));
        this.songProgress.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.titleRender.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.authorRender.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.manager.getCurrentTrack() != null && button == 0 && (this.checkClick(this.titleRender, mouseX, mouseY) || this.checkClick(this.authorRender, mouseX, mouseY)) && GuiTrackUtils.openURI(this.manager.getCurrentTrack().getInfo().getURI())) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkClick(ScrollingTextRenderer renderer, double mouseX, double mouseY) {
        if (!(mouseX >= (double)renderer.getX())) return false;
        if (!(mouseY >= (double)renderer.getY())) return false;
        if (!(mouseX < (double)(renderer.getX() + (float)renderer.getWidth()))) return false;
        float f = renderer.getY();
        Minecraft.func_71410_x().field_71466_p.getClass();
        if (!(mouseY < (double)(f + (float)(9 + 1) * renderer.getScale()))) return false;
        return true;
    }

    private <B extends Widget> B addButton(B button) {
        this.buttons.add(button);
        this.disableButtons.add(button);
        return button;
    }

    private <B extends Widget> B addButtonNonDisable(B button) {
        this.buttons.add(button);
        return button;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public ScrollingTextRenderer getTitleRender() {
        return this.titleRender;
    }

    public ScrollingTextRenderer getAuthorRender() {
        return this.authorRender;
    }

    public void copyTitleRendererState(ScrollingTextRenderer renderer) {
        this.titleRender.copyState(renderer);
    }

    public void copyAuthorRendererState(ScrollingTextRenderer renderer) {
        this.authorRender.copyState(renderer);
    }
}

