/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import info.u_team.music_player.gui.BetterScrollableListEntry;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.GuiMusicPlayerList;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.music_player.musicplayer.playlist.Skip;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ImageToggleButton;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import org.apache.commons.lang3.tuple.Pair;

class GuiMusicPlayerListEntry
extends BetterScrollableListEntry<GuiMusicPlayerListEntry> {
    private final Playlists playlists;
    private final Playlist playlist;
    private final ImageToggleButton playPlaylistButton;
    private final ImageButton openPlaylistButton;
    private final ImageButton deletePlaylistButton;

    public GuiMusicPlayerListEntry(GuiMusicPlayerList gui, Playlists playlists, Playlist playlist) {
        this.playlists = playlists;
        this.playlist = playlist;
        this.playPlaylistButton = (ImageToggleButton)this.addButton((Widget)new ImageToggleButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_PLAY, MusicPlayerResources.TEXTURE_STOP, playlist.equals(playlists.getPlaying())));
        this.playPlaylistButton.field_230693_o_ = !playlists.isPlayingLock();
        this.playPlaylistButton.setPressable(() -> {
            boolean play = this.playPlaylistButton.isToggled();
            if (playlists.isPlayingLock()) {
                return;
            }
            playlists.setPlaying(null);
            gui.func_231039_at__().stream().filter(entry -> entry != this).forEach(entry -> entry.playPlaylistButton.setToggled(false));
            Runnable runnable = () -> {
                ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
                if (play) {
                    if (!playlist.isEmpty()) {
                        playlists.setPlaying(playlist);
                        Pair<LoadedTracks, IAudioTrack> pair = playlist.getFirstTrack();
                        playlist.setPlayable((LoadedTracks)pair.getLeft(), (IAudioTrack)pair.getRight());
                        if (((LoadedTracks)pair.getLeft()).hasError() || pair.getRight() == null) {
                            playlist.skip(Skip.FORWARD);
                        }
                        manager.setTrackQueue(playlist);
                        manager.start();
                    } else {
                        playlists.setPlaying(null);
                        playlist.setStopable();
                        manager.stop();
                        this.playPlaylistButton.setToggled(false);
                    }
                } else {
                    playlists.setPlaying(null);
                    playlist.setStopable();
                    manager.stop();
                }
                playlists.removePlayingLock();
                if (this.minecraft.field_71462_r instanceof GuiMusicPlayer) {
                    GuiMusicPlayer musicplayergui = (GuiMusicPlayer)this.minecraft.field_71462_r;
                    GuiMusicPlayerList newGui = musicplayergui.getPlaylistsList();
                    newGui.func_231039_at__().forEach(entry -> {
                        entry.playPlaylistButton.field_230693_o_ = true;
                    });
                } else if (this.minecraft.field_71462_r instanceof GuiMusicPlaylist) {
                    GuiMusicPlaylist musicplaylistgui = (GuiMusicPlaylist)this.minecraft.field_71462_r;
                    musicplaylistgui.getTrackList().updateAllEntries();
                }
            };
            gui.func_231039_at__().forEach(entry -> {
                entry.playPlaylistButton.field_230693_o_ = false;
            });
            playlists.setPlayingLock();
            if (!playlist.isLoaded()) {
                playlist.load(runnable);
            } else {
                runnable.run();
            }
        });
        this.openPlaylistButton = (ImageButton)this.addButton((Widget)new ImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_OPEN));
        this.openPlaylistButton.setPressable(() -> this.minecraft.func_147108_a((Screen)new GuiMusicPlaylist(playlist)));
        this.deletePlaylistButton = (ImageButton)this.addButton((Widget)new ImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_CLEAR));
        this.deletePlaylistButton.setPressable(() -> gui.removePlaylist(this));
    }

    public void func_230432_a_(MatrixStack matrixStack, int slotIndex, int entryY, int entryX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        String name = this.playlist.getName();
        if (name.isEmpty()) {
            name = "\u00a7o" + MusicPlayerLocalization.getTranslation("gui.musicplayer.playlists.no_name", new Object[0]);
        }
        this.minecraft.field_71466_p.func_238421_b_(matrixStack, name, (float)(entryX + 5), (float)(entryY + 5), this.playlist.equals(this.playlists.getPlaying()) ? 33791 : 0xFFF00F);
        this.minecraft.field_71466_p.func_238421_b_(matrixStack, this.playlist.getEntrySize() + " " + MusicPlayerLocalization.getTranslation(this.playlist.getEntrySize() > 1 ? "gui.musicplayer.playlists.entries" : "gui.musicplayer.playlists.entry", new Object[0]), (float)(entryX + 5), (float)(entryY + 30), 0xFFFFFF);
        this.playPlaylistButton.field_230690_l_ = entryWidth - 65;
        this.playPlaylistButton.field_230691_m_ = entryY + 12;
        this.playPlaylistButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.openPlaylistButton.field_230690_l_ = entryWidth - 40;
        this.openPlaylistButton.field_230691_m_ = entryY + 12;
        this.openPlaylistButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.deletePlaylistButton.field_230690_l_ = entryWidth - 15;
        this.deletePlaylistButton.field_230691_m_ = entryY + 12;
        this.deletePlaylistButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }
}

