/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.settings;

import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.gui.settings.GuiMusicPlayerSettingsMixerDeviceList;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.settings.IngameOverlayPosition;
import info.u_team.music_player.musicplayer.settings.Settings;
import info.u_team.u_team_core.gui.elements.ActiveButton;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.gui.render.ScrollingTextRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiMusicPlayerSettings
extends BetterScreen {
    private final Screen previousGui;
    private GuiMusicPlayerSettingsMixerDeviceList mixerDeviceList;
    private GuiControls controls;

    public GuiMusicPlayerSettings(Screen previousGui) {
        super((ITextComponent)new StringTextComponent("musicplayersettings"));
        this.previousGui = previousGui;
    }

    protected void init() {
        this.addButton((Widget)new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK, button -> this.minecraft.func_147108_a(this.previousGui)));
        Settings settings = MusicPlayerManager.getSettingsManager().getSettings();
        ActiveButton toggleKeyWorkInGuiButton = (ActiveButton)this.addButton((Widget)new ActiveButton(12, 60, this.width / 2 - 24, 20, MusicPlayerLocalization.getTranslation("gui.settings.toggle.key_in_gui", new Object[0]), -2130771713));
        toggleKeyWorkInGuiButton.setActive(settings.isKeyWorkInGui());
        toggleKeyWorkInGuiButton.setPressable(() -> {
            settings.setKeyWorkInGui(!settings.isKeyWorkInGui());
            toggleKeyWorkInGuiButton.setActive(settings.isKeyWorkInGui());
        });
        ActiveButton toggleIngameMenueDisplayButton = (ActiveButton)this.addButton((Widget)new ActiveButton(this.width / 2 + 14, 60, this.width / 2 - 24, 20, MusicPlayerLocalization.getTranslation("gui.settings.toggle.menue_overlay", new Object[0]), -2130771713));
        toggleIngameMenueDisplayButton.setActive(settings.isShowIngameMenueOverlay());
        toggleIngameMenueDisplayButton.setPressable(() -> {
            settings.setShowIngameMenueOverlay(!settings.isShowIngameMenueOverlay());
            toggleIngameMenueDisplayButton.setActive(settings.isShowIngameMenueOverlay());
        });
        ActiveButton toggleIngameDisplayButton = (ActiveButton)this.addButton((Widget)new ActiveButton(12, 90, this.width / 2 - 24, 20, MusicPlayerLocalization.getTranslation("gui.settings.toggle.ingame_overlay", new Object[0]), -2130771713));
        toggleIngameDisplayButton.setActive(settings.isShowIngameOverlay());
        toggleIngameDisplayButton.setPressable(() -> {
            settings.setShowIngameOverlay(!settings.isShowIngameOverlay());
            toggleIngameDisplayButton.setActive(settings.isShowIngameOverlay());
        });
        UButton ingameOverlayPositionButton = (UButton)this.addButton((Widget)new UButton(this.width / 2 + 14, 90, this.width / 2 - 24, 20, MusicPlayerLocalization.getTranslation("gui.settings.position.overlay", new Object[0]) + ": " + MusicPlayerLocalization.getTranslation(settings.getIngameOverlayPosition().getLocalization(), new Object[0])));
        ingameOverlayPositionButton.setPressable(() -> {
            settings.setIngameOverlayPosition(IngameOverlayPosition.forwardCycle(settings.getIngameOverlayPosition()));
            ingameOverlayPositionButton.setMessage(MusicPlayerLocalization.getTranslation("gui.settings.position.overlay", new Object[0]) + ": " + MusicPlayerLocalization.getTranslation(settings.getIngameOverlayPosition().getLocalization(), new Object[0]));
        });
        this.mixerDeviceList = new GuiMusicPlayerSettingsMixerDeviceList(this.width - 24, this.height, 133, 183, 12, this.width - 12);
        this.children.add(this.mixerDeviceList);
        this.controls = new GuiControls(this, 5, this.width);
        this.children.add(this.controls);
    }

    public void tick() {
        this.controls.tick();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        ScrollingTextRender titleRender = this.controls.getTitleRender();
        ScrollingTextRender authorRender = this.controls.getAuthorRender();
        this.init(minecraft, width, height);
        this.controls.setTitleRender(titleRender);
        this.controls.setAuthorRender(authorRender);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderDirtBackground(0);
        this.mixerDeviceList.render(mouseX, mouseY, partialTicks);
        this.font.func_211126_b(MusicPlayerLocalization.getTranslation("gui.settings.mixer_device_selection", new Object[0]), 13.0f, 117.0f, 0xFFFFFF);
        this.controls.drawScreen(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }
}

