/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist.search;

import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchList;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryMusicTrack;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntryPlaylist;
import info.u_team.music_player.gui.playlist.search.SearchProvider;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.UButton;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.Language;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class GuiMusicSearch
extends BetterScreen {
    private final Playlist playlist;
    private TextFieldWidget urlField;
    private TextFieldWidget searchField;
    private final GuiMusicSearchList searchList;
    private SearchProvider searchProvider;
    private String information;
    private int informationTicks;
    private int maxTicksInformation;

    public GuiMusicSearch(Playlist playlist) {
        super((ITextComponent)new StringTextComponent("musicsearch"));
        this.playlist = playlist;
        this.searchList = new GuiMusicSearchList();
        this.searchProvider = SearchProvider.YOUTUBE;
    }

    protected void init() {
        ImageButton backButton = (ImageButton)this.addButton((Widget)new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK));
        backButton.setPressable(() -> this.minecraft.func_147108_a((Screen)new GuiMusicPlaylist(this.playlist)));
        this.urlField = new TextFieldWidget(this.font, 10, 35, this.width / 2 - 10, 20, ""){

            public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, this.func_146179_b(), key);
                return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
            }
        };
        this.urlField.func_146203_f(10000);
        this.children.add(this.urlField);
        Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        String lang = language != null ? language.getCode() : null;
        UButton openFileButton = (UButton)this.addButton((Widget)new UButton(this.width / 2 + 10, 34, this.width / 4 - 15, 22, MusicPlayerLocalization.getTranslation("gui.search.load.file", new Object[0])));
        openFileButton.setPressable(() -> {
            String response = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)GuiMusicSearch.getSearchLoadFileTitle(lang), null, null, (CharSequence)GuiMusicSearch.getSearchLoadFiles(lang), (boolean)false);
            if (response != null) {
                this.searchList.clear();
                this.addTrack(response);
            }
        });
        UButton openFolderButton = (UButton)this.addButton((Widget)new UButton((int)((double)this.width * 0.75) + 5, 34, this.width / 4 - 15, 22, MusicPlayerLocalization.getTranslation("gui.search.load.folder", new Object[0])));
        openFolderButton.setPressable(() -> {
            String response = TinyFileDialogs.tinyfd_selectFolderDialog((CharSequence)GuiMusicSearch.getSearchLoadFolderTitle(lang), (CharSequence)System.getProperty("user.home"));
            if (response != null) {
                this.searchList.clear();
                try (Stream<Path> stream = Files.list(Paths.get(response, new String[0]));){
                    stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> this.addTrack(path.toString()));
                }
                catch (IOException ex) {
                    this.setInformation(TextFormatting.RED + ex.getMessage(), 150);
                }
            }
        });
        ImageButton searchButton = (ImageButton)this.addButton((Widget)new ImageButton(10, 76, 24, 24, this.searchProvider.getLogo()));
        searchButton.setPressable(() -> {
            this.searchProvider = SearchProvider.toggle(this.searchProvider);
            searchButton.setResource(this.searchProvider.getLogo());
        });
        this.searchField = new TextFieldWidget(this.font, 40, 78, this.width - 51, 20, ""){

            public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
                GuiMusicSearch.this.keyFromTextField(this, GuiMusicSearch.this.searchProvider.getPrefix() + this.func_146179_b(), key);
                return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
            }

            public boolean changeFocus(boolean p_changeFocus_1_) {
                System.out.println("CHANGEED FOR Search FIELD to " + p_changeFocus_1_);
                return super.changeFocus(p_changeFocus_1_);
            }
        };
        this.searchField.func_146203_f(1000);
        this.searchField.func_146195_b(true);
        this.setFocused((IGuiEventListener)this.searchField);
        this.children.add(this.searchField);
        UButton addAllButton = (UButton)this.addButton((Widget)new UButton(this.width - 110, 105, 100, 20, MusicPlayerLocalization.getTranslation("gui.search.add_all", new Object[0])));
        addAllButton.setPressable(() -> {
            List<GuiMusicSearchListEntryPlaylist> list = this.searchList.children().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryPlaylist).map(entry -> (GuiMusicSearchListEntryPlaylist)((Object)((Object)entry))).collect(Collectors.toList());
            if (list.size() > 0) {
                list.forEach(entry -> this.playlist.add(entry.getTrackList()));
            } else {
                this.searchList.children().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryMusicTrack).map(entry -> (GuiMusicSearchListEntryMusicTrack)((Object)((Object)entry))).filter(entry -> !entry.isPlaylistEntry()).forEach(entry -> this.playlist.add(entry.getTrack()));
            }
            this.setInformation(TextFormatting.GREEN + MusicPlayerLocalization.getTranslation("gui.search.added_all", new Object[0]), 150);
        });
        this.searchList.updateSettings(this.width - 24, this.height, 130, this.height - 10, 12, this.width - 12);
        this.children.add(this.searchList);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String urlFieldText = this.urlField.func_146179_b();
        boolean urlFieldFocus = this.urlField.isFocused() && this.getFocused() == this.urlField;
        String searchFieldText = this.searchField.func_146179_b();
        boolean searchFieldFocus = this.searchField.isFocused() && this.getFocused() == this.searchField;
        this.init(minecraft, width, height);
        this.urlField.func_146180_a(urlFieldText);
        this.urlField.func_146195_b(urlFieldFocus);
        if (urlFieldFocus) {
            this.setFocused((IGuiEventListener)this.urlField);
        }
        this.searchField.func_146180_a(searchFieldText);
        this.searchField.func_146195_b(searchFieldFocus);
        if (searchFieldFocus) {
            this.setFocused((IGuiEventListener)this.searchField);
        }
    }

    public void tick() {
        this.urlField.func_146178_a();
        this.searchField.func_146178_a();
        ++this.informationTicks;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderDirtBackground(0);
        this.searchList.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.minecraft.field_71466_p, MusicPlayerLocalization.getTranslation("gui.search.header", new Object[0]), this.width / 2, 5, 0xFFFFFF);
        this.drawString(this.minecraft.field_71466_p, MusicPlayerLocalization.getTranslation("gui.search.search.uri", new Object[0]), 10, 20, 0xFFFFFF);
        this.drawString(this.minecraft.field_71466_p, MusicPlayerLocalization.getTranslation("gui.search.search.file", new Object[0]), 10 + this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.minecraft.field_71466_p, MusicPlayerLocalization.getTranslation("gui.search.search.search", new Object[0]), 10, 63, 0xFFFFFF);
        if (this.information != null && this.informationTicks <= this.maxTicksInformation) {
            this.drawString(this.minecraft.field_71466_p, this.information, 15, 110, 0xFFFFFF);
        }
        this.urlField.render(mouseX, mouseY, partialTicks);
        this.searchField.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.urlField.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((IGuiEventListener)this.urlField);
            this.urlField.func_146195_b(true);
            this.searchField.func_146195_b(false);
            return true;
        }
        if (this.searchField.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((IGuiEventListener)this.searchField);
            this.searchField.func_146195_b(true);
            this.urlField.func_146195_b(false);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void setInformation(String information, int maxTicksInformation) {
        this.information = information;
        this.maxTicksInformation = maxTicksInformation;
        this.informationTicks = 0;
    }

    private void keyFromTextField(TextFieldWidget field, String text, int key) {
        if (field.func_146176_q() && field.isFocused() && (key == 257 || key == 335)) {
            this.searchList.clear();
            this.addTrack(text);
            field.func_146180_a("");
        }
    }

    private void addTrack(String uri) {
        MusicPlayerManager.getPlayer().getTrackSearch().getTracks(uri, result -> this.minecraft.execute(() -> {
            if (result.hasError()) {
                this.setInformation(TextFormatting.RED + result.getErrorMessage(), 150);
            } else if (result.isList()) {
                IAudioTrackList list = result.getTrackList();
                if (!list.isSearch()) {
                    this.searchList.add(new GuiMusicSearchListEntryPlaylist(this, this.playlist, list));
                }
                list.getTracks().forEach(track -> this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, (IAudioTrack)track, !list.isSearch())));
            } else {
                IAudioTrack track2 = result.getTrack();
                this.searchList.add(new GuiMusicSearchListEntryMusicTrack(this, this.playlist, track2, false));
            }
        }));
    }

    private static String getSearchLoadFileTitle(String lang) {
        switch (lang) {
            case "jp_jp": {
                return "\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u3080";
            }
            case "ko_kr": {
                return "\ud30c\uc77c \ubd88\ub7ec\uc624\uae30";
            }
            case "pt_br": {
                return "Subir arquivo";
            }
            case "ru_ru": {
                return "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b";
            }
            case "zn_cn": {
                return "\u52a0\u8f7d\u6587\u4ef6";
            }
            case "zn_tw": {
                return "\u8f09\u5165\u6a94\u6848";
            }
            case "de_de": {
                return "Lade eine Datei";
            }
        }
        return "Load file";
    }

    private static String getSearchLoadFiles(String lang) {
        switch (lang) {
            case "jp_jp": {
                return "\u30df\u30e5\u30fc\u30b8\u30c3\u30af\u30d5\u30a1\u30a4\u30eb";
            }
            case "ko_kr": {
                return "\uc74c\uc545 \ud30c\uc77c";
            }
            case "pt_br": {
                return "arquivos de m\u00fasica";
            }
            case "ru_ru": {
                return "\u0424\u0430\u0439\u043b\u044b \u0441 \u043c\u0443\u0437\u044b\u043a\u043e\u0439";
            }
            case "zn_cn": {
                return "\u97f3\u4e50\u6587\u4ef6";
            }
            case "zn_tw": {
                return "\u97f3\u6a02\u6a94\u6848";
            }
            case "de_de": {
                return "Musikdatein";
            }
        }
        return "Music files";
    }

    private static String getSearchLoadFolderTitle(String lang) {
        switch (lang) {
            case "jp_jp": {
                return "\u30d5\u30a9\u30eb\u30c0\u3092\u8aad\u307f\u8fbc\u3080";
            }
            case "ko_kr": {
                return "\ud3f4\ub354 \ubd88\ub7ec\uc624\uae30";
            }
            case "pt_br": {
                return "Pasta de download";
            }
            case "ru_ru": {
                return "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0430\u043f\u043a\u0443";
            }
            case "zn_cn": {
                return "\u52a0\u8f7d\u6587\u4ef6\u5939";
            }
            case "zn_tw": {
                return "\u8f09\u5165\u8cc7\u6599\u593e";
            }
            case "de_de": {
                return "Lade einen Ordner";
            }
        }
        return "Load folder";
    }
}

