/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist;

import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistList;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearch;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.render.ScrollingTextRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiMusicPlaylist
extends BetterScreen {
    private final Playlist playlist;
    private final GuiMusicPlaylistList trackList;
    private ImageButton addTracksButton;
    private GuiControls controls;

    public GuiMusicPlaylist(Playlist playlist) {
        super((ITextComponent)new StringTextComponent("musicplaylist"));
        this.playlist = playlist;
        this.trackList = new GuiMusicPlaylistList(playlist);
        if (!playlist.isLoaded()) {
            playlist.load(() -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    Minecraft.func_71410_x().execute(() -> {
                        if (Minecraft.func_71410_x().field_71462_r == this) {
                            this.trackList.addAllEntries();
                            if (this.addTracksButton != null) {
                                this.addTracksButton.active = true;
                            }
                        }
                    });
                }
            });
        }
    }

    protected void init() {
        ImageButton backButton = (ImageButton)this.addButton((Widget)new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK));
        backButton.setPressable(() -> this.minecraft.func_147108_a((Screen)new GuiMusicPlayer()));
        this.addTracksButton = (ImageButton)this.addButton((Widget)new ImageButton(this.width - 35, 20, 22, 22, MusicPlayerResources.TEXTURE_ADD));
        this.addTracksButton.setPressable(() -> this.minecraft.func_147108_a((Screen)new GuiMusicSearch(this.playlist)));
        if (!this.playlist.isLoaded()) {
            this.addTracksButton.active = false;
        }
        this.trackList.updateSettings(this.width - 24, this.height, 50, this.height - 10, 12, this.width - 12);
        this.trackList.addAllEntries();
        this.children.add(this.trackList);
        this.controls = new GuiControls(this, 5, this.width);
        this.children.add(this.controls);
    }

    public void tick() {
        this.controls.tick();
        this.trackList.tick();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        ScrollingTextRender titleRender = this.controls.getTitleRender();
        ScrollingTextRender authorRender = this.controls.getAuthorRender();
        this.init(minecraft, width, height);
        this.controls.setTitleRender(titleRender);
        this.controls.setAuthorRender(authorRender);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderDirtBackground(0);
        this.trackList.render(mouseX, mouseY, partialTicks);
        this.controls.drawScreen(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }

    public GuiMusicPlaylistList getTrackList() {
        return this.trackList;
    }
}

