/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.controls;

import info.u_team.music_player.gui.BetterNestedGui;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiMusicProgressBar;
import info.u_team.music_player.gui.settings.GuiMusicPlayerSettings;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.MusicPlayerUtils;
import info.u_team.music_player.musicplayer.settings.Repeat;
import info.u_team.music_player.musicplayer.settings.Settings;
import info.u_team.u_team_core.gui.elements.ActiveImageButton;
import info.u_team.u_team_core.gui.elements.BetterFontSlider;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ToggleImageButton;
import info.u_team.u_team_core.gui.render.ScrollingTextRender;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;

public class GuiControls
extends FocusableGui
implements BetterNestedGui {
    private final int middleX;
    private final int y;
    private final int width;
    private final boolean small;
    private final int buttonSize;
    private final int halfButtonSize;
    private final List<Widget> buttons;
    private final List<Widget> disableButtons;
    private final List<IGuiEventListener> children;
    private final ITrackManager manager;
    private final ToggleImageButton playButton;
    private final GuiMusicProgressBar songProgress;
    private ScrollingTextRender titleRender;
    private ScrollingTextRender authorRender;

    public GuiControls(Screen gui, int y, int width) {
        boolean isIngame;
        this.y = y;
        this.width = width;
        this.middleX = width / 2;
        this.buttons = new ArrayList<Widget>();
        this.disableButtons = new ArrayList<Widget>();
        this.children = new ArrayList<IGuiEventListener>();
        this.manager = MusicPlayerManager.getPlayer().getTrackManager();
        Minecraft mc = Minecraft.func_71410_x();
        boolean isSettings = gui instanceof GuiMusicPlayerSettings;
        this.small = isIngame = gui instanceof IngameMenuScreen;
        this.buttonSize = this.small ? 15 : 20;
        this.halfButtonSize = this.buttonSize / 2;
        this.playButton = this.addButton(new ToggleImageButton(this.middleX - this.halfButtonSize, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_PLAY, MusicPlayerResources.TEXTURE_PAUSE));
        this.playButton.toggle(!this.manager.isPaused());
        this.playButton.setPressable(() -> {
            boolean play = this.playButton.isToggled();
            this.manager.setPaused(!play);
        });
        ImageButton skipForwardButton = this.addButton(new ImageButton(this.middleX + this.halfButtonSize + 5, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SKIP_FORWARD));
        skipForwardButton.setPressable(() -> MusicPlayerUtils.skipForward());
        ImageButton skipBackButton = this.addButton(new ImageButton(this.middleX - (this.buttonSize + this.halfButtonSize + 5), y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SKIP_BACK));
        skipBackButton.setPressable(() -> MusicPlayerUtils.skipBack());
        Settings settings = MusicPlayerManager.getSettingsManager().getSettings();
        ActiveImageButton shuffleButton = this.addButton(new ActiveImageButton(this.middleX - (2 * this.buttonSize + this.halfButtonSize + 10), y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SHUFFLE, -2130771713));
        Runnable updateShuffleButton = () -> shuffleButton.setActive(settings.isShuffle());
        updateShuffleButton.run();
        shuffleButton.setPressable(() -> {
            settings.setShuffle(!settings.isShuffle());
            updateShuffleButton.run();
        });
        ActiveImageButton repeatButton = this.addButton(new ActiveImageButton(this.middleX + this.buttonSize + this.halfButtonSize + 10, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_REPEAT, -2130771713));
        Runnable updateRepeatButton = () -> {
            repeatButton.setActive(settings.getRepeat().isActive());
            repeatButton.setResource(settings.getRepeat().getResource());
        };
        updateRepeatButton.run();
        repeatButton.setPressable(() -> {
            settings.setRepeat(Repeat.forwardCycle(settings.getRepeat()));
            updateRepeatButton.run();
        });
        this.songProgress = new GuiMusicProgressBar(this.manager, this.middleX - (this.small ? 50 : 100), y + (this.small ? 20 : 30), this.small ? 100 : 200, this.small ? 3 : 5, this.small ? 0.5f : 1.0f);
        this.children.add((IGuiEventListener)this.songProgress);
        if (!isSettings) {
            ImageButton settingsButton = this.addButtonNonDisable(new ImageButton(width - 16, 1, 15, 15, MusicPlayerResources.TEXTURE_SETTINGS));
            settingsButton.setPressable(() -> mc.func_147108_a((Screen)new GuiMusicPlayerSettings(gui)));
        }
        if (isIngame) {
            ImageButton guiButton = this.addButtonNonDisable(new ImageButton(width - 32, 1, 15, 15, MusicPlayerResources.TEXTURE_OPEN));
            guiButton.setPressable(() -> mc.func_147108_a((Screen)new GuiMusicPlayer()));
        }
        int volumeY = width - (70 + (isIngame ? 33 : (!isSettings ? 17 : 1)));
        this.addButtonNonDisable(new BetterFontSlider(volumeY, 1, 70, 15, MusicPlayerLocalization.getTranslation("gui.controls.volume", new Object[0]) + ": ", "%", 0.0, 100.0, settings.getVolume(), false, true, 0.7f, slider -> {
            settings.setVolume(slider.getValueInt());
            MusicPlayerManager.getPlayer().setVolume(settings.getVolume());
        }){

            public boolean isMouseOver(double mouseX, double mouseY) {
                return this.active;
            }
        });
        this.titleRender = new ScrollingTextRender(() -> mc.field_71466_p, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedTitle()));
        this.titleRender.setStepSize(0.5f);
        this.titleRender.setColor(0xFFFF00);
        this.titleRender.setSpeedTime(35);
        this.authorRender = new ScrollingTextRender(() -> mc.field_71466_p, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedAuthor()));
        this.authorRender.setStepSize(0.5f);
        this.authorRender.setColor(0xFFFF00);
        this.authorRender.setScale(0.75f);
        this.authorRender.setSpeedTime(35);
        this.disableButtons.forEach(button -> {
            button.active = false;
        });
        this.buttons.forEach(this.children::add);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return true;
    }

    public void tick() {
        if (this.manager.getCurrentTrack() == null) {
            this.disableButtons.forEach(button -> {
                button.active = false;
            });
        } else {
            this.disableButtons.forEach(button -> {
                button.active = true;
            });
        }
        this.playButton.toggle(!this.manager.isPaused());
    }

    public List<? extends IGuiEventListener> children() {
        return this.children;
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.buttons.forEach(button -> button.render(mouseX, mouseY, partialTicks));
        this.songProgress.render(mouseX, mouseY, partialTicks);
        int textRenderWidth = this.middleX - (2 * this.buttonSize + this.halfButtonSize + 10) - (this.small ? 15 : 35);
        this.titleRender.setWidth(textRenderWidth);
        this.authorRender.setWidth(textRenderWidth);
        int textRenderY = this.small ? this.y : this.y + 2;
        this.titleRender.draw(this.small ? 10.0f : 25.0f, (float)textRenderY);
        this.authorRender.draw(this.small ? 10.0f : 25.0f, (float)(textRenderY + 10));
    }

    private <B extends Widget> B addButton(B button) {
        this.buttons.add(button);
        this.disableButtons.add(button);
        return button;
    }

    private <B extends Widget> B addButtonNonDisable(B button) {
        this.buttons.add(button);
        return button;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public ScrollingTextRender getTitleRender() {
        return this.titleRender;
    }

    public void setTitleRender(ScrollingTextRender titleRender) {
        this.titleRender = titleRender;
    }

    public ScrollingTextRender getAuthorRender() {
        return this.authorRender;
    }

    public void setAuthorRender(ScrollingTextRender authorRender) {
        this.authorRender = authorRender;
    }
}

