/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui;

import info.u_team.music_player.gui.BetterScrollableListEntry;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.GuiMusicPlayerList;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ToggleImageButton;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import org.apache.commons.lang3.tuple.Pair;

class GuiMusicPlayerListEntry
extends BetterScrollableListEntry<GuiMusicPlayerListEntry> {
    private final Playlists playlists;
    private final Playlist playlist;
    private final ToggleImageButton playPlaylistButton;
    private final ImageButton openPlaylistButton;
    private final ImageButton deletePlaylistButton;

    public GuiMusicPlayerListEntry(GuiMusicPlayerList gui, Playlists playlists, Playlist playlist) {
        this.playlists = playlists;
        this.playlist = playlist;
        this.playPlaylistButton = (ToggleImageButton)this.addButton((Widget)new ToggleImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_PLAY, MusicPlayerResources.TEXTURE_STOP));
        this.playPlaylistButton.toggle(playlist.equals(playlists.getPlaying()));
        this.playPlaylistButton.active = !playlists.isPlayingLock();
        this.playPlaylistButton.setPressable(() -> {
            boolean play = this.playPlaylistButton.isToggled();
            if (playlists.isPlayingLock()) {
                return;
            }
            playlists.setPlaying(null);
            gui.children().stream().filter(entry -> entry != this).forEach(entry -> entry.playPlaylistButton.toggle(false));
            Runnable runnable = () -> {
                ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
                if (play) {
                    if (!playlist.isEmpty()) {
                        playlists.setPlaying(playlist);
                        Pair<LoadedTracks, IAudioTrack> pair = playlist.getFirstTrack();
                        playlist.setPlayable((LoadedTracks)pair.getLeft(), (IAudioTrack)pair.getRight());
                        manager.setTrackQueue(playlist);
                        manager.start();
                    } else {
                        playlists.setPlaying(null);
                        playlist.setStopable();
                        manager.stop();
                        this.playPlaylistButton.toggle(false);
                    }
                } else {
                    playlists.setPlaying(null);
                    playlist.setStopable();
                    manager.stop();
                }
                playlists.removePlayingLock();
                if (this.mc.field_71462_r instanceof GuiMusicPlayer) {
                    GuiMusicPlayer musicplayergui = (GuiMusicPlayer)this.mc.field_71462_r;
                    GuiMusicPlayerList newGui = musicplayergui.getPlaylistsList();
                    newGui.children().forEach(entry -> {
                        entry.playPlaylistButton.active = true;
                    });
                } else if (this.mc.field_71462_r instanceof GuiMusicPlaylist) {
                    GuiMusicPlaylist musicplaylistgui = (GuiMusicPlaylist)this.mc.field_71462_r;
                    musicplaylistgui.getTrackList().updateAllEntries();
                }
            };
            gui.children().forEach(entry -> {
                entry.playPlaylistButton.active = false;
            });
            playlists.setPlayingLock();
            if (!playlist.isLoaded()) {
                playlist.load(runnable);
            } else {
                runnable.run();
            }
        });
        this.openPlaylistButton = (ImageButton)this.addButton((Widget)new ImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_OPEN));
        this.openPlaylistButton.setPressable(() -> this.mc.func_147108_a((Screen)new GuiMusicPlaylist(playlist)));
        this.deletePlaylistButton = (ImageButton)this.addButton((Widget)new ImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_CLEAR));
        this.deletePlaylistButton.setPressable(() -> gui.removePlaylist(this));
    }

    public void render(int slotIndex, int entryY, int entryX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        String name = this.playlist.getName();
        if (name.isEmpty()) {
            name = "\u00a7o" + MusicPlayerLocalization.getTranslation("gui.musicplayer.playlists.no_name", new Object[0]);
        }
        this.mc.field_71466_p.func_211126_b(name, (float)(entryX + 5), (float)(entryY + 5), this.playlist.equals(this.playlists.getPlaying()) ? 33791 : 0xFFF00F);
        this.mc.field_71466_p.func_211126_b(this.playlist.getEntrySize() + " " + MusicPlayerLocalization.getTranslation(this.playlist.getEntrySize() > 1 ? "gui.musicplayer.playlists.entries" : "gui.musicplayer.playlists.entry", new Object[0]), (float)(entryX + 5), (float)(entryY + 30), 0xFFFFFF);
        this.playPlaylistButton.x = entryWidth - 65;
        this.playPlaylistButton.y = entryY + 12;
        this.playPlaylistButton.render(mouseX, mouseY, partialTicks);
        this.openPlaylistButton.x = entryWidth - 40;
        this.openPlaylistButton.y = entryY + 12;
        this.openPlaylistButton.render(mouseX, mouseY, partialTicks);
        this.deletePlaylistButton.x = entryWidth - 15;
        this.deletePlaylistButton.y = entryY + 12;
        this.deletePlaylistButton.render(mouseX, mouseY, partialTicks);
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }
}

