/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.dependency;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Platform;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class TinyFdHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TINYFD_CLASS = "org.lwjgl.util.tinyfd.TinyFileDialogs";
    private static TinyFdClassLoader classLoader;
    private static Class<?> tinyFdClass;
    private static MethodHandle openFileDialogHandle;
    private static MethodHandle selectFolderDialogHandle;

    public static void load(Set<URL> url) {
        classLoader = new TinyFdClassLoader(url);
        classLoader.addTransformer(TINYFD_CLASS, classNode -> {
            classNode.visitSource(".dynamic", null);
            MethodNode method = classNode.methods.stream().filter(node -> node.name.equals("<clinit>")).findFirst().get();
            method.name = "__$$_clinit";
            method.access = 4105;
            ListIterator iterator = method.instructions.iterator();
            for (int index = 0; index < 9; ++index) {
                iterator.next();
                iterator.remove();
            }
            method = new MethodNode();
            method.name = "<clinit>";
            method.desc = "()V";
            method.exceptions = Collections.emptyList();
            method.access = 8;
            method.visitCode();
            Label label = new Label();
            method.visitLabel(label);
            method.visitLineNumber(40000, label);
            method.visitMethodInsn(184, Type.getInternalName(TinyFdHelper.class), "loadTinyFdLibrary", "()V", false);
            method.visitInsn(177);
            method.visitMaxs(1, 0);
            method.visitEnd();
            classNode.methods.add(0, method);
            method = new MethodNode();
            method.name = "__$$_load_native_library";
            method.desc = "(Ljava/lang/String;)V";
            method.exceptions = Arrays.asList(Type.getInternalName(UnsatisfiedLinkError.class));
            method.access = 4105;
            method.visitCode();
            label = new Label();
            method.visitLabel(label);
            method.visitLineNumber(50000, label);
            method.visitVarInsn(25, 0);
            method.visitMethodInsn(184, Type.getInternalName(System.class), "load", "(Ljava/lang/String;)V", false);
            method.visitInsn(177);
            method.visitMaxs(1, 1);
            method.visitEnd();
            classNode.methods.add(0, method);
            classNode.visitEnd();
        });
        try {
            tinyFdClass = Class.forName(TINYFD_CLASS, true, classLoader);
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            openFileDialogHandle = lookup.findStatic(tinyFdClass, "tinyfd_openFileDialog", MethodType.methodType(String.class, CharSequence.class, CharSequence.class, PointerBuffer.class, CharSequence.class, Boolean.TYPE));
            selectFolderDialogHandle = lookup.findStatic(tinyFdClass, "tinyfd_selectFolderDialog", MethodType.methodType(String.class, CharSequence.class, CharSequence.class));
        }
        catch (Throwable th) {
            throw new RuntimeException("Cannot load tinyfd", th);
        }
    }

    public static void loadTinyFdLibrary() throws Throwable {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        Method mapLibraryNameMethod = Platform.class.getDeclaredMethod("mapLibraryName", String.class);
        mapLibraryNameMethod.setAccessible(true);
        MethodHandle mapLibraryNameHandle = lookup.unreflect(mapLibraryNameMethod);
        String libraryName = mapLibraryNameHandle.invoke(Platform.get(), Platform.mapLibraryNameBundled((String)"lwjgl_tinyfd"));
        URL libraryUrl = classLoader.getResource(libraryName);
        if (libraryUrl == null) {
            throw new IllegalStateException("Cannot bind tinyfd native library");
        }
        Path baseDirectory = TinyFdHelper.createExtractDirectory();
        Path libraryPath = baseDirectory.resolve(System.currentTimeMillis() + "_" + libraryName);
        File libraryFile = libraryPath.toFile();
        FileUtils.copyURLToFile((URL)libraryUrl, (File)libraryFile);
        String absolutePath = libraryFile.getAbsolutePath();
        LOGGER.info("Load tinyfd libary from {} ", (Object)absolutePath);
        Class<?> clazz = Class.forName(TINYFD_CLASS, false, classLoader);
        lookup.findStatic(clazz, "__$$_load_native_library", MethodType.methodType(Void.TYPE, String.class)).invoke(absolutePath);
        lookup.findStatic(clazz, "__$$_clinit", MethodType.methodType(Void.TYPE)).invoke();
    }

    private static Path createExtractDirectory() {
        try {
            Path baseDirectory = Paths.get(System.getProperty("java.io.tmpdir", "/tmp"), "musicplayer-tinyfd-tmp");
            try {
                FileUtils.deleteDirectory((File)baseDirectory.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Files.createDirectories(baseDirectory, new FileAttribute[0]);
            return baseDirectory;
        }
        catch (IOException unused) {
            try {
                return Files.createTempDirectory("musicplayer-tinyfd-tmp", new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot create extract directory for tinyfd", ex);
            }
        }
    }

    public static String openFileDialog(CharSequence aTitle, CharSequence aDefaultPathAndFile, PointerBuffer aFilterPatterns, CharSequence aSingleFilterDescription, boolean aAllowMultipleSelects) {
        try {
            return openFileDialogHandle.invoke(aTitle, aDefaultPathAndFile, aFilterPatterns, aSingleFilterDescription, aAllowMultipleSelects);
        }
        catch (Throwable th) {
            throw new RuntimeException("Cannot invoke tinyfd_openFileDialog", th);
        }
    }

    public static String selectFolderDialog(CharSequence aTitle, CharSequence aDefaultPath) {
        try {
            return selectFolderDialogHandle.invoke(aTitle, aDefaultPath);
        }
        catch (Throwable th) {
            throw new RuntimeException("Cannot invoke tinyfd_selectFolderDialog", th);
        }
    }

    private static class TinyFdClassLoader
    extends URLClassLoader {
        private final Map<String, Consumer<ClassNode>> transformers = new HashMap<String, Consumer<ClassNode>>();
        private final ClassLoader ourClassLoader = this.getClass().getClassLoader();

        TinyFdClassLoader(Set<URL> url) {
            super((URL[])url.stream().toArray(URL[]::new), (ClassLoader)null);
        }

        void addTransformer(String className, Consumer<ClassNode> node) {
            this.transformers.put(className, node);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Consumer<ClassNode> transformer = this.transformers.get(name);
            if (transformer != null) {
                String resourceName = name.replace('.', '/') + ".class";
                try (InputStream inputStream = Optional.ofNullable(this.getResourceAsStream(resourceName)).orElseGet(() -> this.ourClassLoader.getResourceAsStream(resourceName));){
                    if (inputStream == null) {
                        throw new ClassCastException();
                    }
                    byte[] transformed = this.transform(transformer, inputStream);
                    LOGGER.info("Transformed {} class successfully", (Object)name);
                    Class<?> clazz = this.defineClass(name, transformed, 0, transformed.length);
                    return clazz;
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Cannot read or transform class bytes", ex);
                }
            }
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                return this.ourClassLoader.loadClass(name);
            }
        }

        @Override
        public URL getResource(String name) {
            return Optional.ofNullable(super.getResource(name)).orElseGet(() -> this.ourClassLoader.getResource(name));
        }

        private byte[] transform(Consumer<ClassNode> transformer, InputStream inputStream) throws IOException {
            ClassNode node = new ClassNode();
            ClassReader reader = new ClassReader(inputStream);
            reader.accept((ClassVisitor)node, 8);
            transformer.accept(node);
            ClassWriter writer = new ClassWriter(reader, 2);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
    }
}

