/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.util;

import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackInfo;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.util.TimeUtil;
import java.net.URI;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;

public final class GuiTrackUtils {
    private static final Minecraft mc = Minecraft.func_71410_x();

    public static String trimToWith(String string, int width) {
        String newString = GuiTrackUtils.mc.field_71466_p.func_78269_a(string, width);
        if (!newString.equals(string)) {
            newString = newString + "...";
        }
        return newString;
    }

    public static void addTrackInfo(IAudioTrack track, int x, int y, int entryWidth, int leftMargin, int titleColor) {
        int textSize = entryWidth - 150 - leftMargin;
        IAudioTrackInfo info = track.getInfo();
        String title = GuiTrackUtils.trimToWith(info.getFixedTitle(), textSize);
        String author = GuiTrackUtils.trimToWith(info.getFixedAuthor(), textSize);
        String duration = GuiTrackUtils.getFormattedDuration(track);
        GuiTrackUtils.mc.field_71466_p.func_78276_b(title, x + leftMargin, y + 5, titleColor);
        GuiTrackUtils.mc.field_71466_p.func_78276_b(author, x + leftMargin + 4, y + 25, 14183708);
        GuiTrackUtils.mc.field_71466_p.func_78276_b(duration, x + entryWidth - 140, y + 15, 0xFFFF00);
    }

    public static boolean openURI(String uri) {
        Style style = new Style();
        try {
            new URI(uri);
            style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, uri));
        }
        catch (Exception ex) {
            style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, uri));
        }
        return GuiTrackUtils.mc.field_71462_r.func_175276_a(new TextComponentString("").func_150255_a(style));
    }

    public static String getFormattedDuration(IAudioTrack track) {
        long seconds;
        if (track == null) {
            seconds = 0L;
        } else {
            IAudioTrackInfo info = track.getInfo();
            if (info.isStream()) {
                return MusicPlayerLocalization.getTranslation("gui.track.duration_undefined", new Object[0]);
            }
            seconds = track.getDuration() / 1000L;
        }
        return TimeUtil.timeConversion(seconds);
    }

    public static String getFormattedPosition(IAudioTrack track) {
        return TimeUtil.timeConversion(track == null ? 0L : track.getPosition() / 1000L);
    }

    public static <T> T getValueOfPlayingTrack(Function<IAudioTrack, T> function) {
        return GuiTrackUtils.getValueOfNullableTrack(MusicPlayerManager.getPlayer().getTrackManager().getCurrentTrack(), function);
    }

    public static <T> T getValueOfNullableTrack(IAudioTrack track, Function<IAudioTrack, T> function) {
        if (track != null) {
            return function.apply(track);
        }
        return null;
    }
}

