/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist.search;

import info.u_team.music_player.gui.playlist.search.GuiMusicSearch;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntry;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.util.TimeUtil;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class GuiMusicSearchListEntryPlaylist
extends GuiMusicSearchListEntry {
    private final IAudioTrackList trackList;
    private final String name;
    private final String duration;

    public GuiMusicSearchListEntryPlaylist(GuiMusicSearch gui, Playlist playlist, IAudioTrackList trackList) {
        this.trackList = trackList;
        this.name = trackList.getName();
        List<IAudioTrack> tracks = trackList.getTracks();
        this.duration = !tracks.parallelStream().anyMatch(track -> track.getInfo().isStream()) ? TimeUtil.timeConversion(tracks.parallelStream().mapToLong(track -> track.getDuration()).sum() / 1000L) : MusicPlayerLocalization.getTranslation("gui.track.duration_undefined", new Object[0]);
        this.addTrackButton.setClickAction(() -> {
            playlist.add(trackList);
            gui.setInformation(TextFormatting.GREEN + MusicPlayerLocalization.getTranslation("gui.search.added_list", new Object[0]), 150);
        });
    }

    @Override
    public void drawEntry(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean mouseInList, float partialTicks) {
        super.drawEntry(entryWidth, entryHeight, mouseX, mouseY, mouseInList, partialTicks);
        this.mc.field_71466_p.func_78276_b(this.name, this.getX() + 5, this.getY() + 15, 16048706);
        this.mc.field_71466_p.func_78276_b(this.duration, this.getX() + entryWidth - 135, this.getY() + 5, 0xFFFF00);
    }

    public IAudioTrackList getTrackList() {
        return this.trackList;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        String uri;
        if (button == 2 && GuiTrackUtils.openURI(uri = this.trackList.getUri())) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

