/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.dependency;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class TinyFdHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TINYFD_CLASS = "org.lwjgl.util.tinyfd.TinyFileDialogs";
    private static TinyFdClassLoader classLoader;
    private static Class<?> tinyFdClass;
    private static MethodHandle openFileDialogHandle;
    private static MethodHandle selectFolderDialogHandle;

    public static void load(Set<URL> url) {
        classLoader = new TinyFdClassLoader(url);
        classLoader.addSyntheticClass(TINYFD_CLASS, classNode -> {
            classNode.access = 1;
            classNode.visitSource(".dynamic", null);
            MethodNode method = new MethodNode();
            method.name = "<clinit>";
            method.desc = "()V";
            method.exceptions = Collections.emptyList();
            method.access = 8;
            method.visitCode();
            Label label = new Label();
            method.visitLabel(label);
            method.visitLineNumber(40000, label);
            method.visitMethodInsn(184, Type.getInternalName(TinyFdHelper.class), "loadTinyFdLibrary", "()V", false);
            method.visitInsn(177);
            method.visitMaxs(0, 0);
            method.visitEnd();
            classNode.methods.add(0, method);
            method = new MethodNode();
            method.name = "__$$_load_native_library";
            method.desc = "(Ljava/lang/String;)V";
            method.exceptions = Arrays.asList(Type.getInternalName(UnsatisfiedLinkError.class));
            method.access = 4105;
            method.visitCode();
            label = new Label();
            method.visitLabel(label);
            method.visitLineNumber(50000, label);
            method.visitVarInsn(25, 0);
            method.visitMethodInsn(184, Type.getInternalName(System.class), "load", "(Ljava/lang/String;)V", false);
            method.visitInsn(177);
            method.visitMaxs(1, 1);
            method.visitEnd();
            classNode.methods.add(method);
            method = new MethodNode();
            method.name = "ntinyfd_openFileDialog";
            method.desc = "(JJIJJI)J";
            method.exceptions = Collections.emptyList();
            method.access = 4377;
            classNode.methods.add(method);
            method = new MethodNode();
            method.name = "ntinyfd_selectFolderDialog";
            method.desc = "(JJ)J";
            method.exceptions = Collections.emptyList();
            method.access = 4377;
            classNode.methods.add(method);
            classNode.visitEnd();
        });
        try {
            tinyFdClass = Class.forName(TINYFD_CLASS, true, classLoader);
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            openFileDialogHandle = lookup.findStatic(tinyFdClass, "ntinyfd_openFileDialog", MethodType.methodType(Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE));
            selectFolderDialogHandle = lookup.findStatic(tinyFdClass, "ntinyfd_selectFolderDialog", MethodType.methodType(Long.TYPE, Long.TYPE, Long.TYPE));
        }
        catch (Throwable th) {
            throw new RuntimeException("Cannot load tinyfd", th);
        }
    }

    public static void loadTinyFdLibrary() throws Throwable {
        String name = Platform.is64Bit() ? "lwjgl_tinyfd" : "lwjgl_tinyfd32";
        String libraryName = System.mapLibraryName(name);
        URL libraryUrl = classLoader.getResource(libraryName);
        if (libraryUrl == null) {
            throw new IllegalStateException("Cannot bind tinyfd native library");
        }
        Path baseDirectory = TinyFdHelper.createExtractDirectory();
        Path libraryPath = baseDirectory.resolve(System.currentTimeMillis() + "_" + libraryName);
        File libraryFile = libraryPath.toFile();
        FileUtils.copyURLToFile((URL)libraryUrl, (File)libraryFile);
        String absolutePath = libraryFile.getAbsolutePath();
        LOGGER.info("Load tinyfd libary from {} ", (Object)absolutePath);
        Class<?> clazz = Class.forName(TINYFD_CLASS, false, classLoader);
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        lookup.findStatic(clazz, "__$$_load_native_library", MethodType.methodType(Void.TYPE, String.class)).invoke(absolutePath);
    }

    private static Path createExtractDirectory() {
        try {
            Path baseDirectory = Paths.get(System.getProperty("java.io.tmpdir", "/tmp"), "musicplayer-tinyfd-tmp");
            try {
                FileUtils.deleteDirectory((File)baseDirectory.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Files.createDirectories(baseDirectory, new FileAttribute[0]);
            return baseDirectory;
        }
        catch (IOException unused) {
            try {
                return Files.createTempDirectory("musicplayer-tinyfd-tmp", new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot create extract directory for tinyfd", ex);
            }
        }
    }

    public static String openFileDialog(String aTitle, String aDefaultPathAndFile, PointerBuffer aFilterPatterns, String aSingleFilterDescription, boolean aAllowMultipleSelects) {
        try {
            long result = openFileDialogHandle.invoke(TinyFdHelper.getAddressOfString(aTitle), TinyFdHelper.getAddressOfString(aDefaultPathAndFile), 0, 0, TinyFdHelper.getAddressOfString(aSingleFilterDescription), aAllowMultipleSelects ? 1 : 0);
            return TinyFdHelper.getStringOfAddress(result);
        }
        catch (Throwable th) {
            throw new RuntimeException("Cannot invoke tinyfd_openFileDialog", th);
        }
    }

    public static String selectFolderDialog(String aTitle, String aDefaultPath) {
        try {
            long result = selectFolderDialogHandle.invoke(TinyFdHelper.getAddressOfString(aTitle), TinyFdHelper.getAddressOfString(aDefaultPath));
            return TinyFdHelper.getStringOfAddress(result);
        }
        catch (Throwable th) {
            throw new RuntimeException("Cannot invoke tinyfd_selectFolderDialog", th);
        }
    }

    private static long getAddressOfString(String string) {
        if (string == null) {
            return 0L;
        }
        Memory pointer = new Memory((long)TinyFdHelper.getStringSize(string));
        pointer.setString(0L, string);
        return Pointer.nativeValue((Pointer)pointer);
    }

    private static String getStringOfAddress(long address) {
        if (address == 0L) {
            return null;
        }
        Pointer pointer = new Pointer(address);
        return pointer.getString(0L);
    }

    private static int getStringSize(String string) {
        try {
            return string.getBytes(Native.DEFAULT_ENCODING).length + 1;
        }
        catch (UnsupportedEncodingException ex) {
            return string.getBytes().length + 1;
        }
    }

    private static class TinyFdClassLoader
    extends URLClassLoader {
        private final Map<String, Consumer<ClassNode>> syntheticClasses = new HashMap<String, Consumer<ClassNode>>();
        private final Map<String, Consumer<ClassNode>> transformers = new HashMap<String, Consumer<ClassNode>>();
        private final ClassLoader ourClassLoader = this.getClass().getClassLoader();

        TinyFdClassLoader(Set<URL> url) {
            super((URL[])url.stream().toArray(URL[]::new), (ClassLoader)null);
        }

        void addTransformer(String className, Consumer<ClassNode> node) {
            this.transformers.put(className, node);
        }

        void addSyntheticClass(String className, Consumer<ClassNode> node) {
            this.syntheticClasses.put(className, node);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Consumer<ClassNode> syntheticClass = this.syntheticClasses.get(name);
            if (syntheticClass != null) {
                byte[] generatedClass = this.syntheticClass(syntheticClass, name);
                LOGGER.info("Defined synthetic {} class successfully", (Object)name);
                return this.defineClass(name, generatedClass, 0, generatedClass.length);
            }
            Consumer<ClassNode> transformer = this.transformers.get(name);
            if (transformer != null) {
                String resourceName = name.replace('.', '/') + ".class";
                try (InputStream inputStream = Optional.ofNullable(this.getResourceAsStream(resourceName)).orElseGet(() -> this.ourClassLoader.getResourceAsStream(resourceName));){
                    if (inputStream == null) {
                        throw new ClassCastException();
                    }
                    byte[] transformed = this.transform(transformer, inputStream);
                    LOGGER.info("Transformed {} class successfully", (Object)name);
                    Class<?> clazz = this.defineClass(name, transformed, 0, transformed.length);
                    return clazz;
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Cannot read or transform class bytes", ex);
                }
            }
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                return this.ourClassLoader.loadClass(name);
            }
        }

        @Override
        public URL getResource(String name) {
            return Optional.ofNullable(super.getResource(name)).orElseGet(() -> this.ourClassLoader.getResource(name));
        }

        private byte[] syntheticClass(Consumer<ClassNode> syntheticClass, String name) {
            ClassNode node = new ClassNode();
            node.version = 52;
            node.name = name.replace('.', '/');
            node.superName = Type.getInternalName(Object.class);
            syntheticClass.accept(node);
            node.access = node.access | 0x1000 | 0x20;
            ClassWriter writer = new ClassWriter(2);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }

        private byte[] transform(Consumer<ClassNode> transformer, InputStream inputStream) throws IOException {
            ClassNode node = new ClassNode();
            ClassReader reader = new ClassReader(inputStream);
            reader.accept((ClassVisitor)node, 8);
            transformer.accept(node);
            ClassWriter writer = new ClassWriter(reader, 2);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
    }
}

