package info.u_team.music_player.gui.playlist.search;

import info.u_team.music_player.init.MusicPlayerResources;
import net.minecraft.class_2960;

public enum SearchProvider {
	
	YOUTUBE("ytsearch:", MusicPlayerResources.TEXTURE_SOCIAL_YOUTUBE),
	SOUNDCLOUD("scsearch:", MusicPlayerResources.TEXTURE_SOCIAL_SOUNDCLOUD);
	
	private final String prefix;
	private final class_2960 logo;
	
	private SearchProvider(String prefix, class_2960 logo) {
		this.prefix = prefix;
		this.logo = logo;
	}
	
	public String getPrefix() {
		return prefix;
	}
	
	public class_2960 getLogo() {
		return logo;
	}
	
	public static SearchProvider toggle(SearchProvider provider) {
		if (provider == YOUTUBE) {
			return SOUNDCLOUD;
		}
		return YOUTUBE;
	}
	
}
