/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.init;

import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.init.MusicPlayerKeys;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.MusicPlayerUtils;
import info.u_team.music_player.musicplayer.SettingsManager;
import info.u_team.music_player.musicplayer.settings.IngameOverlayPosition;
import info.u_team.music_player.render.RenderOverlayMusicDisplay;
import info.u_team.u_team_core.api.event.ClientEvents;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import java.util.List;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_1041;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class MusicPlayerEventHandler {
    private static final SettingsManager settingsManager = MusicPlayerManager.getSettingsManager();
    private static RenderOverlayMusicDisplay overlayRender;
    private static ScrollingText titleRender;
    private static ScrollingText authorRender;

    public static void onKeyInput() {
        MusicPlayerEventHandler.handleKeyboard(false, -1, -1);
    }

    public static boolean onKeyboardPressed(class_437 screen, int keyCode, int scanCode, int modifiers) {
        if (settingsManager.getSettings().isKeyWorkInGui()) {
            return MusicPlayerEventHandler.handleKeyboard(true, keyCode, scanCode);
        }
        return false;
    }

    private static boolean handleKeyboard(boolean gui, int keyCode, int scanCode) {
        boolean handled;
        ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
        if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.OPEN, gui, keyCode, scanCode)) {
            class_310 mc = class_310.method_1551();
            if (!(mc.field_1755 instanceof GuiMusicPlayer)) {
                mc.method_1507((class_437)new GuiMusicPlayer());
            }
            handled = true;
        } else if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.PAUSE, gui, keyCode, scanCode)) {
            if (manager.getCurrentTrack() != null) {
                manager.setPaused(!manager.isPaused());
            }
            handled = true;
        } else if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.SKIP_FORWARD, gui, keyCode, scanCode)) {
            if (manager.getCurrentTrack() != null) {
                MusicPlayerUtils.skipForward();
            }
            handled = true;
        } else if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.SKIP_BACK, gui, keyCode, scanCode)) {
            if (manager.getCurrentTrack() != null) {
                MusicPlayerUtils.skipBack();
            }
            handled = true;
        } else {
            handled = false;
        }
        return handled;
    }

    private static boolean isKeyDown(class_304 binding, boolean gui, int keyCode, int scanCode) {
        if (gui) {
            class_3675.class_306 key = class_3675.method_15985((int)keyCode, (int)scanCode);
            return key != class_3675.field_16237 && key.equals((Object)KeyBindingHelper.getBoundKeyOf((class_304)binding));
        }
        return binding.method_1436();
    }

    public static void onRenderGameOverlay(class_332 guiGraphics, float partialTick) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 == null && settingsManager.getSettings().isShowIngameOverlay()) {
            IngameOverlayPosition position = settingsManager.getSettings().getIngameOverlayPosition();
            if (overlayRender == null) {
                overlayRender = new RenderOverlayMusicDisplay();
            }
            class_1041 window = mc.method_22683();
            int screenWidth = window.method_4486();
            int screenHeight = window.method_4502();
            int height = overlayRender.getHeight();
            int width = overlayRender.getWidth();
            int x = position.isLeft() ? 3 : screenWidth - 3 - width;
            int y = position.isUp() ? 3 : screenHeight - 3 - height;
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416((float)x, (float)y, 500.0f);
            overlayRender.method_25394(guiGraphics, 0, 0, partialTick);
            poseStack.method_22909();
        }
    }

    private static void onPreInitScreen(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (screen instanceof class_433 && settingsManager.getSettings().isShowIngameMenueOverlay()) {
            screen.method_25396().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> {
                titleRender = controls.getTitleRender();
                authorRender = controls.getAuthorRender();
            });
        }
    }

    private static void onPostInitScreen(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (screen instanceof class_433 && settingsManager.getSettings().isShowIngameMenueOverlay()) {
            GuiControls controls = new GuiControls(screen, 3, screen.field_22789);
            if (titleRender != null) {
                controls.copyTitleRendererState(titleRender);
                titleRender = null;
            }
            if (authorRender != null) {
                controls.copyAuthorRendererState(authorRender);
                authorRender = null;
            }
            List list = screen.method_25396();
            list.add(controls);
        }
    }

    private static void onDrawScreenPost(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (settingsManager.getSettings().isShowIngameMenueOverlay()) {
            screen.method_25396().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> controls.method_25394(guiGraphics, mouseX, mouseY, partialTick));
        }
    }

    private static void onMouseReleasePre(class_437 screen, double mouseX, double mouseY, int button) {
        if (settingsManager.getSettings().isShowIngameMenueOverlay()) {
            screen.method_25396().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> controls.method_25406(mouseX, mouseY, button));
        }
    }

    private static void onClientTick(class_437 screen) {
        if (settingsManager.getSettings().isShowIngameMenueOverlay()) {
            screen.method_25396().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(GuiControls::tick);
        }
    }

    public static void register() {
        ScreenEvents.BEFORE_INIT.register(MusicPlayerEventHandler::onPreInitScreen);
        ScreenEvents.AFTER_INIT.register(MusicPlayerEventHandler::onPostInitScreen);
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_433) {
                ScreenEvents.afterRender((class_437)screen).register(MusicPlayerEventHandler::onDrawScreenPost);
                ScreenMouseEvents.beforeMouseRelease((class_437)screen).register(MusicPlayerEventHandler::onMouseReleasePre);
                ScreenEvents.afterTick((class_437)screen).register(MusicPlayerEventHandler::onClientTick);
            }
        });
        ClientEvents.registerScreenAfterKeyPressed(MusicPlayerEventHandler::onKeyboardPressed);
    }
}

