package info.u_team.music_player.gui.playlist;

import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearch;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class GuiMusicPlaylist extends BetterScreen {
	
	private final Playlist playlist;
	
	private final GuiMusicPlaylistList trackList;
	
	private ImageButton addTracksButton;
	
	private GuiControls controls;
	
	public GuiMusicPlaylist(Playlist playlist) {
		super(class_2561.method_43470("musicplaylist"));
		this.playlist = playlist;
		
		trackList = new GuiMusicPlaylistList(playlist);
		
		if (!playlist.isLoaded()) {
			playlist.load(() -> {
				if (class_310.method_1551().field_1755 == this) { // Check if gui is still open
					class_310.method_1551().execute(() -> {
						if (class_310.method_1551().field_1755 == this) { // Recheck gui because this is async on the main thread.
							trackList.addAllEntries();
							if (addTracksButton != null) {
								addTracksButton.field_22763 = true;
							}
						}
					});
				}
			});
		}
	}
	
	@Override
	protected void method_25426() {
		final ImageButton backButton = method_37063(new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK));
		backButton.setPressable(() -> field_22787.method_1507(new GuiMusicPlayer()));
		
		addTracksButton = method_37063(new ImageButton(field_22789 - 35, 20, 22, 22, MusicPlayerResources.TEXTURE_ADD));
		addTracksButton.setPressable(() -> field_22787.method_1507(new GuiMusicSearch(playlist)));
		
		if (!playlist.isLoaded()) {
			addTracksButton.field_22763 = false;
		}
		
		trackList.updateSettings(field_22789 - 24, field_22790, 50, field_22790 - 10, 12, field_22789 - 12);
		trackList.addAllEntries();
		method_25429(trackList);
		
		controls = new GuiControls(this, 5, field_22789);
		method_25429(controls);
	}
	
	@Override
	public void method_25393() {
		controls.tick();
		trackList.tick();
	}
	
	@Override
	public void method_25410(class_310 minecraft, int width, int height) {
		final ScrollingText titleRender = controls.getTitleRender();
		final ScrollingText authorRender = controls.getAuthorRender();
		this.method_25423(minecraft, width, height);
		controls.copyTitleRendererState(titleRender);
		controls.copyAuthorRendererState(authorRender);
	}
	
	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		method_25434(guiGraphics);
		trackList.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
		controls.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
		super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
	}
	
	public GuiMusicPlaylistList getTrackList() {
		return trackList;
	}
	
}
