/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist;

import info.u_team.music_player.gui.BetterScrollableList;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntry;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryError;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryFunctions;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryLoading;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryMusicTrack;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryPlaylistStart;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryPlaylistTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import java.util.ArrayList;
import net.minecraft.class_350;

public class GuiMusicPlaylistList
extends BetterScrollableList<GuiMusicPlaylistListEntry> {
    private final Playlist playlist;
    private boolean tracksLoaded;
    private int selectIndex;

    public GuiMusicPlaylistList(Playlist playlist) {
        super(0, 0, 0, 0, 0, 0, 40, 20);
        this.playlist = playlist;
        this.method_25321((class_350.class_351)new GuiMusicPlaylistListEntryLoading());
    }

    private void addLoadedTrackToGui(LoadedTracks loadedTracks) {
        Playlists playlists = MusicPlayerManager.getPlaylistManager().getPlaylists();
        ArrayList<GuiMusicPlaylistListEntryFunctions> list = new ArrayList<GuiMusicPlaylistListEntryFunctions>();
        if (loadedTracks.hasError()) {
            list.add(new GuiMusicPlaylistListEntryError(this, playlists, this.playlist, loadedTracks, loadedTracks.getErrorMessage()));
        } else if (loadedTracks.isTrack()) {
            list.add(new GuiMusicPlaylistListEntryMusicTrack(this, playlists, this.playlist, loadedTracks));
        } else if (loadedTracks.isTrackList()) {
            GuiMusicPlaylistListEntryPlaylistStart start = new GuiMusicPlaylistListEntryPlaylistStart(this, playlists, this.playlist, loadedTracks);
            list.add(start);
            loadedTracks.getTrackList().getTracks().forEach(track -> {
                GuiMusicPlaylistListEntryPlaylistTrack entry = new GuiMusicPlaylistListEntryPlaylistTrack(start, playlists, this.playlist, loadedTracks, (IAudioTrack)track);
                start.addEntry(entry);
                list.add((GuiMusicPlaylistListEntryFunctions)((Object)entry));
            });
        }
        list.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
    }

    public void addAllEntries() {
        if (!this.playlist.isLoaded()) {
            return;
        }
        if (!this.tracksLoaded) {
            this.method_25339();
            this.playlist.getLoadedTracks().forEach(this::addLoadedTrackToGui);
            this.tracksLoaded = true;
        }
    }

    public void removeAllEntries() {
        this.method_25339();
        this.tracksLoaded = false;
    }

    public void updateAllEntries() {
        this.removeAllEntries();
        this.addAllEntries();
    }

    public void setSelectedEntryWhenMove(GuiMusicPlaylistListEntry entry, int indexOffset) {
        int index = this.method_25396().lastIndexOf((Object)entry) + indexOffset;
        if (index >= 0 && index < this.method_25396().size()) {
            this.selectIndex = index;
        }
    }

    protected boolean method_25332(int index) {
        return index == this.selectIndex;
    }

    public void setSelected(GuiMusicPlaylistListEntry entry) {
        if (entry != null) {
            this.selectIndex = this.method_25396().indexOf((Object)entry);
        }
        super.method_25313((class_350.class_351)entry);
    }

    public void tick() {
        this.method_25396().forEach(GuiMusicPlaylistListEntry::tick);
    }
}

