package info.u_team.music_player.init;

import java.util.List;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.MusicPlayerUtils;
import info.u_team.music_player.musicplayer.SettingsManager;
import info.u_team.music_player.musicplayer.settings.IngameOverlayPosition;
import info.u_team.music_player.render.RenderOverlayMusicDisplay;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_1041;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_3675.class_306;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class MusicPlayerEventHandler {
	
	private static final SettingsManager SETTINGS_MANAGER = MusicPlayerManager.getSettingsManager();
	
	// Used to listen to keyboard events
	
	public static void onKeyInput() {
		handleKeyboard(false, -1, -1);
	}
	
	public static boolean onKeyboardPressed(int keyCode, int scanCode) {
		if (SETTINGS_MANAGER.getSettings().isKeyWorkInGui()) {
			return handleKeyboard(true, keyCode, scanCode);
		}
		return false;
	}
	
	private static boolean handleKeyboard(boolean gui, int keyCode, int scanCode) {
		final boolean handled;
		final ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
		if (isKeyDown(MusicPlayerKeys.OPEN, gui, keyCode, scanCode)) {
			final class_310 mc = class_310.method_1551();
			if (!(mc.field_1755 instanceof GuiMusicPlayer)) {
				mc.method_1507(new GuiMusicPlayer());
			}
			handled = true;
		} else if (isKeyDown(MusicPlayerKeys.PAUSE, gui, keyCode, scanCode)) {
			if (manager.getCurrentTrack() != null) {
				manager.setPaused(!manager.isPaused());
			}
			handled = true;
		} else if (isKeyDown(MusicPlayerKeys.SKIP_FORWARD, gui, keyCode, scanCode)) {
			if (manager.getCurrentTrack() != null) {
				MusicPlayerUtils.skipForward();
			}
			handled = true;
		} else if (isKeyDown(MusicPlayerKeys.SKIP_BACK, gui, keyCode, scanCode)) {
			if (manager.getCurrentTrack() != null) {
				MusicPlayerUtils.skipBack();
			}
			handled = true;
		} else {
			handled = false;
		}
		return handled;
	}
	
	private static boolean isKeyDown(class_304 binding, boolean gui, int keyCode, int scanCode) {
		if (gui) {
			final class_306 key = class_3675.method_15985(keyCode, scanCode);
			return key != class_3675.field_16237 && key.equals(KeyBindingHelper.getBoundKeyOf(binding));
		} else {
			return binding.method_1436();
		}
	}
	
	private static RenderOverlayMusicDisplay overlayRender;
	
	// Render overlay
	
	public static void onRenderGameOverlay(class_4587 poseStack, float partialTick) {
		final class_310 mc = class_310.method_1551();
		if (SETTINGS_MANAGER.getSettings().isShowIngameOverlay()) {
			final IngameOverlayPosition position = SETTINGS_MANAGER.getSettings().getIngameOverlayPosition();
			
			if (overlayRender == null) {
				overlayRender = new RenderOverlayMusicDisplay();
			}
			
			final class_1041 window = mc.method_22683();
			final int screenWidth = window.method_4486();
			final int screenHeight = window.method_4502();
			
			final int height = overlayRender.getHeight();
			final int width = overlayRender.getWidth();
			
			final int x;
			if (position.isLeft()) {
				x = 3;
			} else {
				x = screenWidth - 3 - width;
			}
			
			final int y;
			if (position.isUp()) {
				y = 3;
			} else {
				y = screenHeight - 3 - height;
			}
			
			poseStack.method_22903();
			poseStack.method_46416(x, y, 500);
			overlayRender.method_25394(poseStack, 0, 0, partialTick);
			poseStack.method_22909();
		}
	}
	
	// Used to add buttons and gui controls to main ingame gui
	
	private static ScrollingText titleRender, authorRender;
	
	private static void onPreInitScreen(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
		if (screen instanceof class_433) {
			if (SETTINGS_MANAGER.getSettings().isShowIngameMenueOverlay()) {
				screen.method_25396().stream() //
						.filter(element -> element instanceof GuiControls) //
						.map(element -> ((GuiControls) element)).findAny() //
						.ifPresent(controls -> {
							titleRender = controls.getTitleRender();
							authorRender = controls.getAuthorRender();
						});
			}
		}
	}
	
	private static void onPostInitScreen(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
		if (screen instanceof class_433) {
			if (SETTINGS_MANAGER.getSettings().isShowIngameMenueOverlay()) {
				final GuiControls controls = new GuiControls(screen, 3, screen.field_22789);
				if (titleRender != null) {
					controls.copyTitleRendererState(titleRender);
					titleRender = null;
				}
				if (authorRender != null) {
					controls.copyAuthorRendererState(authorRender);
					authorRender = null;
				}
				@SuppressWarnings("unchecked")
				final List<class_364> list = (List<class_364>) screen.method_25396();
				list.add(controls);
			}
		}
	}
	
	private static void onDrawScreenPost(class_437 screen, class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		if (SETTINGS_MANAGER.getSettings().isShowIngameMenueOverlay()) {
			screen.method_25396().stream() //
					.filter(element -> element instanceof GuiControls) //
					.map(element -> ((GuiControls) element)).findAny() //
					.ifPresent(controls -> controls.method_25394(poseStack, mouseX, mouseY, partialTick));
		}
	}
	
	private static void onMouseReleasePre(class_437 screen, double mouseX, double mouseY, int button) {
		if (SETTINGS_MANAGER.getSettings().isShowIngameMenueOverlay()) {
			screen.method_25396().stream() //
					.filter(element -> element instanceof GuiControls) //
					.map(element -> ((GuiControls) element)).findAny() //
					.ifPresent(controls -> controls.method_25406(mouseX, mouseY, button));
		}
	}
	
	private static void onClientTick(class_437 screen) {
		if (SETTINGS_MANAGER.getSettings().isShowIngameMenueOverlay()) {
			screen.method_25396().stream() //
					.filter(element -> element instanceof GuiControls) //
					.map(element -> ((GuiControls) element)).findAny() //
					.ifPresent(GuiControls::tick);
		}
	}
	
	public static void register() {
		ScreenEvents.BEFORE_INIT.register(MusicPlayerEventHandler::onPreInitScreen);
		ScreenEvents.AFTER_INIT.register(MusicPlayerEventHandler::onPostInitScreen);
		
		ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
			if (screen instanceof class_433) {
				ScreenEvents.afterRender(screen).register(MusicPlayerEventHandler::onDrawScreenPost);
				ScreenMouseEvents.beforeMouseRelease(screen).register(MusicPlayerEventHandler::onMouseReleasePre);
				ScreenEvents.afterTick(screen).register(MusicPlayerEventHandler::onClientTick);
			}
		});
	}
	
}
