/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.musicplayer.playlist;

import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.lavaplayer.api.search.ISearchResult;
import info.u_team.music_player.musicplayer.playlist.Skip;
import info.u_team.music_player.util.WrappedObject;
import java.util.List;

public class LoadedTracks {
    private final WrappedObject<String> uri;
    private String errorMessage;
    private String title;
    private IAudioTrack track;
    private IAudioTrackList trackList;

    public LoadedTracks(WrappedObject<String> uri) {
        this.uri = uri;
        this.errorMessage = "Not loaded yet";
    }

    public LoadedTracks(WrappedObject<String> uri, ISearchResult result) {
        this.uri = uri;
        if (result.hasError()) {
            this.errorMessage = result.getErrorMessage();
        } else if (!result.isList()) {
            this.track = result.getTrack();
            this.title = this.track.getInfo().getTitle();
        } else {
            this.trackList = result.getTrackList();
            this.title = this.trackList.getName();
        }
    }

    public LoadedTracks(WrappedObject<String> uri, IAudioTrack track) {
        this.uri = uri;
        this.track = track;
        this.title = track.getInfo().getTitle();
    }

    public LoadedTracks(WrappedObject<String> uri, IAudioTrackList trackList) {
        this.uri = uri;
        this.trackList = trackList;
        this.title = trackList.getName();
    }

    public WrappedObject<String> getUri() {
        return this.uri;
    }

    public boolean hasError() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isTrack() {
        return this.trackList == null && this.track != null;
    }

    public boolean isTrackList() {
        return this.trackList != null && this.track == null;
    }

    public IAudioTrack getTrack() {
        return this.track;
    }

    public IAudioTrackList getTrackList() {
        return this.trackList;
    }

    public IAudioTrack getFirstTrack() {
        if (this.isTrack()) {
            return this.track;
        }
        if (this.isTrackList()) {
            return (IAudioTrack)this.trackList.getTracks().get(0);
        }
        return null;
    }

    public IAudioTrack getLastTrack() {
        if (this.isTrack()) {
            return this.track;
        }
        if (this.isTrackList()) {
            return (IAudioTrack)this.trackList.getTracks().get(this.trackList.getTracks().size() - 1);
        }
        return null;
    }

    public IAudioTrack getOtherTrack(IAudioTrack track, Skip skip) {
        if (this.isTrack() || !this.isTrackList()) {
            return null;
        }
        List list = this.trackList.getTracks();
        int index = list.indexOf(track);
        int newIndex = index + skip.getValue();
        if (newIndex >= 0 && newIndex < list.size()) {
            return (IAudioTrack)list.get(newIndex);
        }
        return null;
    }
}

