package info.u_team.music_player.gui;

import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_CREATE_PLAYLIST_ADD_LIST;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_CREATE_PLAYLIST_INSERT_NAME;
import static info.u_team.music_player.init.MusicPlayerLocalization.getTranslation;

import org.apache.commons.lang3.StringUtils;

import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;

public class GuiMusicPlayer extends BetterScreen {
	
	private class_342 namePlaylistField;
	
	private GuiMusicPlayerList playlistsList;
	
	private GuiControls controls;
	
	public GuiMusicPlayer() {
		super(class_2561.method_43470("musicplayer"));
	}
	
	@Override
	protected void method_25426() {
		method_37063(new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK, button -> field_22787.method_1507(null)));
		
		namePlaylistField = new class_342(field_22793, 100, 60, field_22789 - 150, 20, class_2561.method_30163(null));
		namePlaylistField.method_1880(500);
		method_25429(namePlaylistField);
		
		final ImageButton addPlaylistButton = method_37063(new ImageButton(field_22789 - 41, 59, 22, 22, MusicPlayerResources.TEXTURE_CREATE));
		addPlaylistButton.setPressable(() -> {
			final String name = namePlaylistField.method_1882();
			if (StringUtils.isBlank(name) || name.equals(getTranslation(GUI_CREATE_PLAYLIST_INSERT_NAME))) {
				namePlaylistField.method_1852(getTranslation(GUI_CREATE_PLAYLIST_INSERT_NAME));
				return;
			}
			playlistsList.addPlaylist(name);
			namePlaylistField.method_1852("");
		});
		
		playlistsList = new GuiMusicPlayerList(12, 90, field_22789 - 24, field_22790 - 100);
		method_25429(playlistsList);
		
		controls = new GuiControls(this, 5, field_22789);
		method_25429(controls);
	}
	
	@Override
	public void method_25410(class_310 minecraft, int width, int height) {
		final String text = namePlaylistField.method_1882();
		final ScrollingText titleRender = controls.getTitleRender();
		final ScrollingText authorRender = controls.getAuthorRender();
		this.method_25423(minecraft, width, height);
		namePlaylistField.method_1852(text);
		controls.copyTitleRendererState(titleRender);
		controls.copyAuthorRendererState(authorRender);
	}
	
	@Override
	public void method_25393() {
		controls.tick();
	}
	
	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
		playlistsList.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
		guiGraphics.method_51433(field_22793, getTranslation(GUI_CREATE_PLAYLIST_ADD_LIST), 20, 65, 0xFFFFFF, false);
		namePlaylistField.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
		controls.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
	}
	
	@Override
	public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		super.method_25420(guiGraphics, mouseX, mouseY, partialTicks);
	}
	
	public GuiMusicPlayerList getPlaylistsList() {
		return playlistsList;
	}
	
}
