/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.musicplayer.playlist;

import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.lavaplayer.api.queue.ITrackQueue;
import info.u_team.music_player.lavaplayer.api.search.ISearchResult;
import info.u_team.music_player.lavaplayer.api.search.ITrackSearch;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Skip;
import info.u_team.music_player.musicplayer.settings.Settings;
import info.u_team.music_player.util.WrappedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.apache.commons.lang3.tuple.Pair;

public class Playlist
implements ITrackQueue {
    public String name;
    public final ArrayList<WrappedObject<String>> uris;
    private final transient Executor executor;
    private transient boolean loaded;
    private final transient ArrayList<LoadedTracks> loadedTracks;
    private transient LoadedTracks nextLoadedTrack;
    private transient IAudioTrack next;
    private transient boolean first;
    private transient Random random;

    private Playlist() {
        this.uris = new ArrayList();
        this.loadedTracks = new ArrayList();
        this.executor = Executors.newSingleThreadExecutor();
    }

    public Playlist(String name) {
        this.name = name;
        this.uris = new ArrayList();
        this.loadedTracks = new ArrayList();
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void load() {
        this.load(() -> {});
    }

    public void load(Runnable runnable) {
        if (this.loaded) {
            return;
        }
        this.executor.execute(() -> {
            this.unload();
            if (this.uris.isEmpty()) {
                this.loaded = true;
                runnable.run();
                return;
            }
            ITrackSearch search = MusicPlayerManager.getPlayer().getTrackSearch();
            this.uris.forEach((Consumer<WrappedObject<String>>)((Consumer<WrappedObject>)uri -> this.loadedTracks.add(new LoadedTracks((WrappedObject<String>)uri))));
            AtomicInteger counterIfReady = new AtomicInteger();
            int index = 0;
            while (index < this.uris.size()) {
                int immutableIndex = index++;
                WrappedObject<String> uri2 = this.uris.get(immutableIndex);
                search.getTracks(uri2.get(), result -> {
                    LoadedTracks loadedTrack = new LoadedTracks(uri2, (ISearchResult)result);
                    this.loadedTracks.set(immutableIndex, loadedTrack);
                    if (counterIfReady.incrementAndGet() == this.loadedTracks.size()) {
                        this.loaded = true;
                        runnable.run();
                    }
                });
            }
        });
    }

    public void unload() {
        this.loadedTracks.clear();
        this.loaded = false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public WrappedObject<String> add(IAudioTrack track) {
        if (!this.loaded) {
            return null;
        }
        WrappedObject<String> uri = new WrappedObject<String>(track.getInfo().getURI());
        int index = this.uris.size();
        this.uris.add(index, uri);
        this.loadedTracks.add(index, new LoadedTracks(uri, track));
        this.save();
        return uri;
    }

    public WrappedObject<String> add(IAudioTrackList trackList) {
        if (!this.loaded) {
            return null;
        }
        if (!trackList.isSearch() && trackList.hasUri()) {
            WrappedObject<String> uri = new WrappedObject<String>(trackList.getUri());
            int index = this.uris.size();
            this.uris.add(index, uri);
            this.loadedTracks.add(index, new LoadedTracks(uri, trackList));
            this.save();
            return uri;
        }
        return null;
    }

    public boolean remove(WrappedObject<String> uri) {
        if (!this.loaded) {
            return false;
        }
        int index = this.uris.indexOf(uri);
        if (index >= 0) {
            this.uris.remove(index);
            this.loadedTracks.remove(index);
            this.save();
            return true;
        }
        return false;
    }

    public boolean move(WrappedObject<String> uri, int value) {
        if (!this.loaded) {
            return false;
        }
        int oldIndex = this.uris.indexOf(uri);
        int newIndex = oldIndex - value;
        if (newIndex >= 0 && newIndex < this.uris.size()) {
            this.uris.add(newIndex, this.uris.remove(oldIndex));
            this.loadedTracks.add(newIndex, this.loadedTracks.remove(oldIndex));
            this.save();
            return true;
        }
        return false;
    }

    public void setName(String name) {
        this.name = name;
        this.save();
    }

    public String getName() {
        return this.name;
    }

    public int getEntrySize() {
        return this.uris.size();
    }

    public Collection<LoadedTracks> getLoadedTracks() {
        return Collections.unmodifiableCollection(this.loadedTracks);
    }

    public boolean isEmpty() {
        return this.uris.isEmpty();
    }

    private void save() {
        MusicPlayerManager.getPlaylistManager().writeToFile();
    }

    public boolean calculateNext() {
        Settings settings = MusicPlayerManager.getSettingsManager().getSettings();
        if (this.nextLoadedTrack == null || this.next == null) {
            return false;
        }
        if (this.first) {
            this.first = false;
            return true;
        }
        if (settings.isSingleRepeat()) {
            return true;
        }
        if (settings.isShuffle()) {
            return this.selectRandomTrack();
        }
        return this.findNextSong(settings, Skip.FORWARD);
    }

    public IAudioTrack getNext() {
        return this.next;
    }

    public boolean skip(Skip skip) {
        Settings settings = MusicPlayerManager.getSettingsManager().getSettings();
        this.first = settings.isShuffle() ? this.selectRandomTrack() : this.findNextSong(settings, skip);
        return this.first;
    }

    public Pair<LoadedTracks, IAudioTrack> getFirstTrack() {
        return this.getTrackAtIndex(0, LoadedTracks::getFirstTrack);
    }

    public Pair<LoadedTracks, IAudioTrack> getLastTrack() {
        return this.getTrackAtIndex(this.loadedTracks.size() - 1, LoadedTracks::getLastTrack);
    }

    private Pair<LoadedTracks, IAudioTrack> getTrackAtIndex(int index, Function<LoadedTracks, IAudioTrack> function) {
        if (this.loadedTracks.isEmpty()) {
            return Pair.of(null, null);
        }
        LoadedTracks loadedTrack = this.loadedTracks.get(index);
        if (loadedTrack == null) {
            return Pair.of(null, null);
        }
        return Pair.of((Object)loadedTrack, (Object)function.apply(loadedTrack));
    }

    public void setPlayable(LoadedTracks loadedTrack, IAudioTrack track) {
        this.setTracks(loadedTrack, track);
        this.first = true;
    }

    public void setStopable() {
        this.nextLoadedTrack = null;
        this.next = null;
    }

    private Pair<LoadedTracks, IAudioTrack> getOtherTrack(LoadedTracks loadedTrack, IAudioTrack track, Skip skip) {
        if (loadedTrack == null) {
            return Pair.of(null, null);
        }
        IAudioTrack nextTrack = loadedTrack.getOtherTrack(track, skip);
        if (nextTrack != null) {
            return Pair.of((Object)loadedTrack, (Object)nextTrack);
        }
        int index = this.loadedTracks.indexOf(loadedTrack);
        if (index == -1) {
            return Pair.of(null, null);
        }
        IntPredicate testIndex = newIndex -> skip == Skip.FORWARD ? newIndex < this.loadedTracks.size() : newIndex >= 0;
        int newIndex2 = index + skip.getValue();
        while (testIndex.test(newIndex2)) {
            LoadedTracks nextValidLoadedTrack = this.getTrackAndValidate(newIndex2);
            if (nextValidLoadedTrack != null) {
                return Pair.of((Object)nextValidLoadedTrack, (Object)(skip == Skip.FORWARD ? nextValidLoadedTrack.getFirstTrack() : nextValidLoadedTrack.getLastTrack()));
            }
            newIndex2 += skip.getValue();
        }
        return Pair.of(null, null);
    }

    private LoadedTracks getTrackAndValidate(int index) {
        if (index <= 0 && index >= this.loadedTracks.size()) {
            return null;
        }
        LoadedTracks loadedTrack = this.loadedTracks.get(index);
        if (loadedTrack.hasError() || !loadedTrack.isTrack() && !loadedTrack.isTrackList()) {
            return null;
        }
        return loadedTrack;
    }

    private void setTracks(LoadedTracks loadedTrack, IAudioTrack track) {
        this.nextLoadedTrack = loadedTrack;
        this.next = track;
    }

    private boolean findNextSong(Settings settings, Skip skip) {
        Pair<LoadedTracks, IAudioTrack> pair = this.getOtherTrack(this.nextLoadedTrack, this.next, skip);
        LoadedTracks loadedTrack = (LoadedTracks)pair.getLeft();
        IAudioTrack track = (IAudioTrack)pair.getRight();
        if (loadedTrack == null || track == null) {
            if (settings.isFinite()) {
                return false;
            }
            if (this.loadedTracks.size() > 0) {
                Pair<LoadedTracks, IAudioTrack> sidePair = skip == Skip.FORWARD ? this.getFirstTrack() : this.getLastTrack();
                LoadedTracks sideLoadedTrack = (LoadedTracks)sidePair.getLeft();
                IAudioTrack sideTrack = (IAudioTrack)sidePair.getRight();
                if (sideLoadedTrack != null && sideTrack != null) {
                    this.setTracks(sideLoadedTrack, sideTrack);
                    return true;
                }
                if (sideLoadedTrack != null) {
                    Pair<LoadedTracks, IAudioTrack> nextValidPair = this.getOtherTrack(sideLoadedTrack, null, skip);
                    LoadedTracks nextValidLoadedTrack = (LoadedTracks)nextValidPair.getLeft();
                    IAudioTrack nextValidTrack = (IAudioTrack)nextValidPair.getRight();
                    if (nextValidLoadedTrack != null && nextValidTrack != null) {
                        this.setTracks(nextValidLoadedTrack, nextValidTrack);
                        return true;
                    }
                }
            }
        } else if (loadedTrack != null && track != null) {
            this.setTracks(loadedTrack, track);
            return true;
        }
        return false;
    }

    private boolean selectRandomTrack() {
        ArrayList shuffleEntries = new ArrayList();
        this.loadedTracks.forEach(loadedTrack -> {
            if (loadedTrack.isTrack()) {
                shuffleEntries.add(Pair.of((Object)loadedTrack, (Object)loadedTrack.getTrack()));
            } else if (loadedTrack.isTrackList()) {
                loadedTrack.getTrackList().getTracks().forEach(track -> shuffleEntries.add(Pair.of((Object)loadedTrack, (Object)track)));
            }
        });
        if (shuffleEntries.isEmpty()) {
            return false;
        }
        if (this.random == null) {
            this.random = new Random();
        }
        Collections.shuffle(shuffleEntries, this.random);
        Pair pair = (Pair)shuffleEntries.get(this.random.nextInt(shuffleEntries.size()));
        this.nextLoadedTrack = (LoadedTracks)pair.getLeft();
        this.next = (IAudioTrack)pair.getRight();
        return true;
    }
}

