package info.u_team.music_player.gui.settings;

import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SETTINGS_MIXER_DEVICE_SELECTION;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SETTINGS_PITCH;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SETTINGS_POSITION_OVERLAY;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SETTINGS_SPEED;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SETTINGS_TOGGLE_INGAME_OVERLAY;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SETTINGS_TOGGLE_KEY_IN_GUI;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SETTINGS_TOGGLE_MENUE_OVERLAY;
import static info.u_team.music_player.init.MusicPlayerLocalization.getTranslation;

import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.init.MusicPlayerColors;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.settings.IngameOverlayPosition;
import info.u_team.music_player.musicplayer.settings.Settings;
import info.u_team.u_team_core.gui.elements.ActivatableButton;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import info.u_team.u_team_core.gui.elements.UButton;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class GuiMusicPlayerSettings extends BetterScreen {
	
	private final class_437 previousGui;
	
	private GuiMusicPlayerSettingsMixerDeviceList mixerDeviceList;
	
	private GuiControls controls;
	
	public GuiMusicPlayerSettings(class_437 previousGui) {
		super(class_2561.method_43470("musicplayersettings"));
		this.previousGui = previousGui;
	}
	
	@Override
	protected void method_25426() {
		method_37063(new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK, button -> field_22787.method_1507(previousGui)));
		
		final Settings settings = MusicPlayerManager.getSettingsManager().getSettings();
		
		final ActivatableButton toggleKeyWorkInGuiButton = method_37063(new ActivatableButton(12, 60, field_22789 / 2 - 24, 20, class_2561.method_30163(getTranslation(GUI_SETTINGS_TOGGLE_KEY_IN_GUI)), settings.isKeyWorkInGui(), MusicPlayerColors.LIGHT_GREEN));
		toggleKeyWorkInGuiButton.setPressable(() -> {
			settings.setKeyWorkInGui(!settings.isKeyWorkInGui());
			toggleKeyWorkInGuiButton.setActivated(settings.isKeyWorkInGui());
		});
		
		final ActivatableButton toggleIngameMenueDisplayButton = method_37063(new ActivatableButton(field_22789 / 2 + 14, 60, field_22789 / 2 - 24, 20, class_2561.method_30163(getTranslation(GUI_SETTINGS_TOGGLE_MENUE_OVERLAY)), settings.isShowIngameMenueOverlay(), MusicPlayerColors.LIGHT_GREEN));
		toggleIngameMenueDisplayButton.setPressable(() -> {
			settings.setShowIngameMenueOverlay(!settings.isShowIngameMenueOverlay());
			toggleIngameMenueDisplayButton.setActivated(settings.isShowIngameMenueOverlay());
		});
		
		final ActivatableButton toggleIngameDisplayButton = method_37063(new ActivatableButton(12, 90, field_22789 / 2 - 24, 20, class_2561.method_30163(getTranslation(GUI_SETTINGS_TOGGLE_INGAME_OVERLAY)), settings.isShowIngameOverlay(), MusicPlayerColors.LIGHT_GREEN));
		toggleIngameDisplayButton.setPressable(() -> {
			settings.setShowIngameOverlay(!settings.isShowIngameOverlay());
			toggleIngameDisplayButton.setActivated(settings.isShowIngameOverlay());
		});
		
		final UButton ingameOverlayPositionButton = method_37063(new UButton(field_22789 / 2 + 14, 90, field_22789 / 2 - 24, 20, class_2561.method_30163(getTranslation(GUI_SETTINGS_POSITION_OVERLAY) + ": " + getTranslation(settings.getIngameOverlayPosition().getLocalization()))));
		ingameOverlayPositionButton.setPressable(() -> {
			settings.setIngameOverlayPosition(IngameOverlayPosition.forwardCycle(settings.getIngameOverlayPosition()));
			ingameOverlayPositionButton.method_25355(class_2561.method_30163(getTranslation(GUI_SETTINGS_POSITION_OVERLAY) + ": " + getTranslation(settings.getIngameOverlayPosition().getLocalization())));
		});
		
		// TODO replace with uslider
		method_37063(new class_357(12, 120, field_22789 / 2 - 24, 20, class_5244.field_39003, MusicPlayerManager.getPlayer().getSpeed() / 4F) {
			
			{
				method_25346();
			}
			
			@Override
			protected void method_25346() {
				method_25355(class_2561.method_43470(getTranslation(GUI_SETTINGS_SPEED) + ": " + Math.round(MusicPlayerManager.getPlayer().getSpeed() * 100F) / 100F));
			}
			
			@Override
			protected void method_25344() {
				MusicPlayerManager.getPlayer().setSpeed((float) class_3532.method_15390(0.1F, 4F, field_22753));
			}
		});
		
		// TODO replace with uslider
		method_37063(new class_357(field_22789 / 2 + 14, 120, field_22789 / 2 - 24, 20, class_5244.field_39003, MusicPlayerManager.getPlayer().getPitch() / 3F) {
			
			{
				method_25346();
			}
			
			@Override
			protected void method_25346() {
				method_25355(class_2561.method_43470(getTranslation(GUI_SETTINGS_PITCH) + ": " + Math.round(MusicPlayerManager.getPlayer().getPitch() * 100F) / 100F));
			}
			
			@Override
			protected void method_25344() {
				MusicPlayerManager.getPlayer().setPitch((float) class_3532.method_15390(0.1F, 3F, field_22753));
			}
		});
		
		mixerDeviceList = new GuiMusicPlayerSettingsMixerDeviceList(12, 163, field_22789 - 24, field_22790 - 173);
		method_25429(mixerDeviceList);
		
		controls = new GuiControls(this, 5, field_22789);
		method_25429(controls);
	}
	
	@Override
	public void method_25393() {
		controls.tick();
	}
	
	@Override
	public void method_25410(class_310 minecraft, int width, int height) {
		final ScrollingText titleRender = controls.getTitleRender();
		final ScrollingText authorRender = controls.getAuthorRender();
		this.method_25423(minecraft, width, height);
		controls.copyTitleRendererState(titleRender);
		controls.copyAuthorRendererState(authorRender);
	}
	
	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
		mixerDeviceList.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
		guiGraphics.method_25303(field_22787.field_1772, getTranslation(GUI_SETTINGS_MIXER_DEVICE_SELECTION), 13, 147, 0xFFFFFF);
		controls.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
	}
	
	@Override
	public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		super.method_25420(guiGraphics, mouseX, mouseY, partialTicks);
	}
	
}
