package info.u_team.music_player.gui.util;

import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_TRACK_DURATION_UNDEFINED;
import static info.u_team.music_player.init.MusicPlayerLocalization.getTranslation;

import java.net.URI;
import java.util.function.Function;
import net.minecraft.class_2558;
import net.minecraft.class_2558.class_2559;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackInfo;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.util.TimeUtil;

public final class GuiTrackUtils {
	
	private static final class_310 MINECRAFT = class_310.method_1551();
	
	public static String trimToWith(String string, int width) {
		String newString = MINECRAFT.field_1772.method_27523(string, width);
		if (!newString.equals(string)) {
			newString += "...";
		}
		return newString;
	}
	
	public static void addTrackInfo(class_4587 matrixStack, IAudioTrack track, int x, int y, int entryWidth, int leftMargin, int titleColor) {
		final int textSize = entryWidth - 150 - leftMargin;
		
		final IAudioTrackInfo info = track.getInfo();
		
		final String title = trimToWith(info.getFixedTitle(), textSize);
		final String author = trimToWith(info.getFixedAuthor(), textSize);
		final String duration = getFormattedDuration(track);
		
		MINECRAFT.field_1772.method_1729(matrixStack, title, x + leftMargin, y + 5, titleColor);
		MINECRAFT.field_1772.method_1729(matrixStack, author, x + leftMargin + 4, y + 25, 0xD86D1C);
		MINECRAFT.field_1772.method_1729(matrixStack, duration, x + entryWidth - 140, y + 15, 0xFFFF00);
	}
	
	public static boolean openURI(String uri) {
		class_2583 style = class_2561.method_30163(null).method_10866();
		try {
			new URI(uri);
			style = style.method_10958(new class_2558(class_2559.field_11749, uri));
		} catch (final Exception ex) {
			style = style.method_10958(new class_2558(class_2559.field_11746, uri));
		}
		return MINECRAFT.field_1755.method_25430(style);
	}
	
	public static String getFormattedDuration(IAudioTrack track) {
		final long seconds;
		if (track == null) {
			seconds = 0;
		} else {
			final IAudioTrackInfo info = track.getInfo();
			if (info.isStream()) {
				return getTranslation(GUI_TRACK_DURATION_UNDEFINED);
			}
			seconds = track.getDuration() / 1000;
		}
		return TimeUtil.timeConversion(seconds);
	}
	
	public static String getFormattedPosition(IAudioTrack track) {
		return TimeUtil.timeConversion(track == null ? 0 : track.getPosition() / 1000);
	}
	
	public static <T> T getValueOfPlayingTrack(Function<IAudioTrack, T> function) {
		return getValueOfNullableTrack(MusicPlayerManager.getPlayer().getTrackManager().getCurrentTrack(), function);
	}
	
	public static <T> T getValueOfNullableTrack(IAudioTrack track, Function<IAudioTrack, T> function) {
		if (track != null) {
			return function.apply(track);
		}
		return null;
	}
	
}
