package info.u_team.music_player.gui.playlist.search;

import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SEARCH_ADDED_ALL;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SEARCH_ADD_ALL;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SEARCH_HEADER;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SEARCH_LOAD_FILE;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SEARCH_LOAD_FOLDER;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SEARCH_SEARCH_FILE;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SEARCH_SEARCH_SEARCH;
import static info.u_team.music_player.init.MusicPlayerLocalization.GUI_SEARCH_SEARCH_URI;
import static info.u_team.music_player.init.MusicPlayerLocalization.getTranslation;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.UButton;

public class GuiMusicSearch extends BetterScreen {
	
	private final Playlist playlist;
	
	private class_342 urlField;
	private class_342 searchField;
	
	private final GuiMusicSearchList searchList;
	
	private SearchProvider searchProvider;
	
	private String information;
	private int informationTicks;
	private int maxTicksInformation;
	
	public GuiMusicSearch(Playlist playlist) {
		super(class_2561.method_43470("musicsearch"));
		this.playlist = playlist;
		searchList = new GuiMusicSearchList();
		searchProvider = SearchProvider.YOUTUBE;
	}
	
	@Override
	protected void method_25426() {
		final ImageButton backButton = method_37063(new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK));
		backButton.setPressable(() -> field_22787.method_1507(new GuiMusicPlaylist(playlist)));
		
		urlField = new class_342(field_22793, 10, 35, field_22789 / 2 - 10, 20, class_2561.method_30163("")) {
			
			@Override
			public boolean method_25404(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
				keyFromTextField(this, method_1882(), key);
				return super.method_25404(key, p_keyPressed_2_, p_keyPressed_3_);
			}
		};
		urlField.method_1880(10000);
		method_25429(urlField);
		
		final String lang = class_310.method_1551().method_1526().method_4669();
		
		final UButton openFileButton = method_37063(new UButton(field_22789 / 2 + 10, 34, field_22789 / 4 - 15, 22, class_2561.method_30163(getTranslation(GUI_SEARCH_LOAD_FILE))));
		openFileButton.setPressable(() -> {
			final String response = TinyFileDialogs.tinyfd_openFileDialog(getSearchLoadFileTitle(lang), null, null, getSearchLoadFiles(lang), false);
			if (response != null) {
				searchList.clear();
				addTrack(response);
			}
		});
		
		final UButton openFolderButton = method_37063(new UButton((int) (field_22789 * 0.75) + 5, 34, field_22789 / 4 - 15, 22, class_2561.method_30163(getTranslation(GUI_SEARCH_LOAD_FOLDER))));
		openFolderButton.setPressable(() -> {
			final String response = TinyFileDialogs.tinyfd_selectFolderDialog(getSearchLoadFolderTitle(lang), System.getProperty("user.home"));
			if (response != null) {
				searchList.clear();
				try (Stream<Path> stream = Files.list(Paths.get(response))) {
					stream.filter(path -> !Files.isDirectory(path)).forEach(path -> addTrack(path.toString()));
				} catch (final IOException ex) {
					setInformation(class_124.field_1061 + ex.getMessage(), 150);
				}
			}
		});
		
		final ImageButton searchButton = method_37063(new ImageButton(10, 76, 24, 24, searchProvider.getLogo()));
		searchButton.setPressable(() -> {
			searchProvider = SearchProvider.toggle(searchProvider);
			searchButton.setImage(searchProvider.getLogo());
		});
		
		searchField = new class_342(field_22793, 40, 78, field_22789 - 51, 20, class_2561.method_30163("")) {
			
			@Override
			public boolean method_25404(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
				keyFromTextField(this, searchProvider.getPrefix() + method_1882(), key);
				return super.method_25404(key, p_keyPressed_2_, p_keyPressed_3_);
			}
			
		};
		searchField.method_1880(1000);
		method_25395(searchField);
		method_25429(searchField);
		
		final UButton addAllButton = method_37063(new UButton(field_22789 - 110, 105, 100, 20, class_2561.method_30163(getTranslation(GUI_SEARCH_ADD_ALL))));
		addAllButton.setPressable(() -> {
			final List<GuiMusicSearchListEntryPlaylist> list = searchList.method_25396().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryPlaylist).map(entry -> (GuiMusicSearchListEntryPlaylist) entry).collect(Collectors.toList());
			if (list.size() > 0) {
				list.forEach(entry -> {
					playlist.add(entry.getTrackList());
				});
			} else {
				searchList.method_25396().stream().filter(entry -> entry instanceof GuiMusicSearchListEntryMusicTrack).map(entry -> (GuiMusicSearchListEntryMusicTrack) entry).filter(entry -> !entry.isPlaylistEntry()).forEach(entry -> {
					playlist.add(entry.getTrack());
				});
			}
			setInformation(class_124.field_1060 + getTranslation(GUI_SEARCH_ADDED_ALL), 150);
		});
		
		searchList.updateSettings(field_22789 - 24, field_22790, 130, field_22790 - 10, 12, field_22789 - 12);
		method_25429(searchList);
	}
	
	@Override
	public void method_25410(class_310 minecraft, int width, int height) {
		final String urlFieldText = urlField.method_1882();
		final boolean urlFieldFocus = urlField.method_25370() && method_25399() == urlField;
		
		final String searchFieldText = searchField.method_1882();
		final boolean searchFieldFocus = searchField.method_25370() && method_25399() == searchField;
		
		method_25423(minecraft, width, height);
		
		urlField.method_1852(urlFieldText);
		urlField.method_25365(urlFieldFocus);
		if (urlFieldFocus) {
			method_25395(urlField);
		}
		
		searchField.method_1852(searchFieldText);
		searchField.method_25365(searchFieldFocus);
		if (searchFieldFocus) {
			method_25395(searchField);
		}
		
	}
	
	@Override
	public void method_25393() {
		urlField.method_1865();
		searchField.method_1865();
		informationTicks++;
	}
	
	@Override
	public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
		method_25434(matrixStack);
		searchList.method_25394(matrixStack, mouseX, mouseY, partialTicks);
		
		method_25300(matrixStack, field_22787.field_1772, getTranslation(GUI_SEARCH_HEADER), field_22789 / 2, 5, 0xFFFFFF);
		method_25303(matrixStack, field_22787.field_1772, getTranslation(GUI_SEARCH_SEARCH_URI), 10, 20, 0xFFFFFF);
		method_25303(matrixStack, field_22787.field_1772, getTranslation(GUI_SEARCH_SEARCH_FILE), 10 + field_22789 / 2, 20, 0xFFFFFF);
		method_25303(matrixStack, field_22787.field_1772, getTranslation(GUI_SEARCH_SEARCH_SEARCH), 10, 63, 0xFFFFFF);
		
		if (information != null && informationTicks <= maxTicksInformation) {
			method_25303(matrixStack, field_22787.field_1772, information, 15, 110, 0xFFFFFF);
		}
		
		urlField.method_25394(matrixStack, mouseX, mouseY, partialTicks);
		searchField.method_25394(matrixStack, mouseX, mouseY, partialTicks);
		super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
	}
	
	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (urlField.method_25402(mouseX, mouseY, button)) {
			method_25395(urlField);
			urlField.method_25365(true);
			searchField.method_25365(false);
			return true;
		} else if (searchField.method_25402(mouseX, mouseY, button)) {
			method_25395(searchField);
			searchField.method_25365(true);
			urlField.method_25365(false);
			return true;
		}
		return super.method_25402(mouseX, mouseY, button);
	}
	
	public void setInformation(String information, int maxTicksInformation) {
		this.information = information;
		this.maxTicksInformation = maxTicksInformation;
		informationTicks = 0;
	}
	
	private void keyFromTextField(class_342 field, String text, int key) {
		if (field.method_1885() && field.method_25370() && (key == GLFW.GLFW_KEY_ENTER || key == GLFW.GLFW_KEY_KP_ENTER)) {
			searchList.clear();
			addTrack(text);
			field.method_1852("");
		}
	}
	
	private void addTrack(String uri) {
		MusicPlayerManager.getPlayer().getTrackSearch().getTracks(uri, result -> {
			field_22787.execute(() -> {
				if (result.hasError()) {
					setInformation(class_124.field_1061 + result.getErrorMessage(), 150);
				} else if (result.isList()) {
					final IAudioTrackList list = result.getTrackList();
					if (!list.isSearch()) {
						searchList.add(new GuiMusicSearchListEntryPlaylist(this, playlist, list));
					}
					list.getTracks().forEach(track -> searchList.add(new GuiMusicSearchListEntryMusicTrack(this, playlist, track, !list.isSearch())));
				} else {
					final IAudioTrack track = result.getTrack();
					searchList.add(new GuiMusicSearchListEntryMusicTrack(this, playlist, track, false));
				}
			});
		});
	}
	
	/**
	 * This method exists instead of a normal translation due to a vulnerability in the TinyFileDialogs library allowing for
	 * command injection.
	 */
	private static String getSearchLoadFileTitle(String lang) {
		return switch (lang) {
		case "jp_jp" -> "ファイルを読み込む";
		case "ko_kr" -> "파일 불러오기";
		case "pt_br" -> "Subir arquivo";
		case "ru_ru" -> "Загрузить файл";
		case "zn_cn" -> "加载文件";
		case "zn_tw" -> "載入檔案";
		case "de_de" -> "Lade eine Datei";
		default -> "Load file";
		};
	}
	
	/**
	 * This method exists instead of a normal translation due to a vulnerability in the TinyFileDialogs library allowing for
	 * command injection.
	 */
	private static String getSearchLoadFiles(String lang) {
		return switch (lang) {
		case "jp_jp" -> "ミュージックファイル";
		case "ko_kr" -> "음악 파일";
		case "pt_br" -> "arquivos de música";
		case "ru_ru" -> "Файлы с музыкой";
		case "zn_cn" -> "音乐文件";
		case "zn_tw" -> "音樂檔案";
		case "de_de" -> "Musikdatein";
		default -> "Music files";
		};
	}
	
	/**
	 * This method exists instead of a normal translation due to a vulnerability in the TinyFileDialogs library allowing for
	 * command injection.
	 */
	private static String getSearchLoadFolderTitle(String lang) {
		return switch (lang) {
		case "jp_jp" -> "フォルダを読み込む";
		case "ko_kr" -> "폴더 불러오기";
		case "pt_br" -> "Pasta de download";
		case "ru_ru" -> "Загрузить папку";
		case "zn_cn" -> "加载文件夹";
		case "zn_tw" -> "載入資料夾";
		case "de_de" -> "Lade einen Ordner";
		default -> "Load folder";
		};
	}
}
