package info.u_team.music_player.gui.playlist;

import java.util.ArrayList;
import java.util.List;

import info.u_team.music_player.gui.BetterScrollableList;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;

public class GuiMusicPlaylistList extends BetterScrollableList<GuiMusicPlaylistListEntry> {
	
	private final Playlist playlist;
	
	private boolean tracksLoaded;
	
	private int selectIndex;
	
	public GuiMusicPlaylistList(Playlist playlist) {
		super(0, 0, 0, 0, 0, 0, 40, 20);
		this.playlist = playlist;
		method_25321(new GuiMusicPlaylistListEntryLoading());
	}
	
	private void addLoadedTrackToGui(LoadedTracks loadedTracks) {
		final Playlists playlists = MusicPlayerManager.getPlaylistManager().getPlaylists();
		final List<GuiMusicPlaylistListEntry> list = new ArrayList<>();
		if (loadedTracks.hasError()) {// Add error gui element
			list.add(new GuiMusicPlaylistListEntryError(this, playlists, playlist, loadedTracks, loadedTracks.getErrorMessage()));
		} else if (loadedTracks.isTrack()) { // Add track gui element
			list.add(new GuiMusicPlaylistListEntryMusicTrack(this, playlists, playlist, loadedTracks));
		} else if (loadedTracks.isTrackList()) { // Add playlist start element and all track sub elements
			final GuiMusicPlaylistListEntryPlaylistStart start = new GuiMusicPlaylistListEntryPlaylistStart(this, playlists, playlist, loadedTracks);
			list.add(start);
			loadedTracks.getTrackList().getTracks().forEach(track -> {
				final GuiMusicPlaylistListEntryPlaylistTrack entry = new GuiMusicPlaylistListEntryPlaylistTrack(start, playlists, playlist, loadedTracks, track);
				start.addEntry(entry);
				list.add(entry);
			});
		}
		list.forEach(this::method_25321);
	}
	
	public void addAllEntries() {
		if (!playlist.isLoaded()) {
			return;
		}
		if (!tracksLoaded) {
			method_25339();
			playlist.getLoadedTracks().forEach(this::addLoadedTrackToGui);
			tracksLoaded = true;
		}
	}
	
	public void removeAllEntries() {
		method_25339();
		tracksLoaded = false;
	}
	
	public void updateAllEntries() {
		removeAllEntries();
		addAllEntries();
	}
	
	public void setSelectedEntryWhenMove(GuiMusicPlaylistListEntry entry, int indexOffset) {
		final int index = method_25396().lastIndexOf(entry) + indexOffset;
		if (index >= 0 && index < method_25396().size()) {
			selectIndex = index;
		}
	}
	
	@Override
	protected boolean method_25332(int index) {
		return index == selectIndex;
	}
	
	@Override
	public void setSelected(GuiMusicPlaylistListEntry entry) {
		if (entry != null) {
			selectIndex = method_25396().indexOf(entry);
		}
		super.method_25313(entry);
	}
	
	public void tick() {
		method_25396().forEach(GuiMusicPlaylistListEntry::tick);
	}
}