/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements.backport;

import info.u_team.u_team_core.gui.elements.backport.GuiEventHandlerNew;
import info.u_team.u_team_core.gui.elements.backport.IGuiEventListener;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiSlotNew
extends GuiEventHandlerNew {
    protected final Minecraft mc;
    public int width;
    public int height;
    public int top;
    public int bottom;
    public int right;
    public int left;
    public final int slotHeight;
    protected boolean centerListVertically = true;
    protected int initialClickY = -2;
    protected double amountScrolled;
    protected int selectedElement;
    protected long lastClicked = Long.MIN_VALUE;
    protected boolean visible = true;
    protected boolean showSelectionBox = true;
    protected boolean hasListHeader;
    public int headerPadding;
    private boolean clickedScrollbar;

    public GuiSlotNew(Minecraft mcIn, int width, int height, int topIn, int bottomIn, int slotHeightIn) {
        this.mc = mcIn;
        this.width = width;
        this.height = height;
        this.top = topIn;
        this.bottom = bottomIn;
        this.slotHeight = slotHeightIn;
        this.left = 0;
        this.right = width;
    }

    public void setDimensions(int widthIn, int heightIn, int topIn, int bottomIn) {
        this.width = widthIn;
        this.height = heightIn;
        this.top = topIn;
        this.bottom = bottomIn;
        this.left = 0;
        this.right = widthIn;
    }

    public void setShowSelectionBox(boolean showSelectionBoxIn) {
        this.showSelectionBox = showSelectionBoxIn;
    }

    protected void setHasListHeader(boolean hasListHeaderIn, int headerPaddingIn) {
        this.hasListHeader = hasListHeaderIn;
        this.headerPadding = headerPaddingIn;
        if (!hasListHeaderIn) {
            this.headerPadding = 0;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected abstract int getSize();

    public void setSelectedEntry(int index) {
    }

    @Override
    protected List<? extends IGuiEventListener> getChildren() {
        return Collections.emptyList();
    }

    protected boolean mouseClicked(int index, int button, double mouseX, double mouseY) {
        return true;
    }

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight + this.headerPadding;
    }

    protected abstract void drawBackground();

    protected void updateItemPos(int entryID, int insideLeft, int yPos, float partialTicks) {
    }

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, int var5, int var6, float var7);

    protected void drawListHeader(int insideLeft, int insideTop, Tessellator tessellatorIn) {
    }

    protected void clickedHeader(int p_148132_1_, int p_148132_2_) {
    }

    protected void renderDecorations(int mouseXIn, int mouseYIn) {
    }

    public int getEntryAt(double x, double y) {
        int i = this.left + this.width / 2 - this.getListWidth() / 2;
        int j = this.left + this.width / 2 + this.getListWidth() / 2;
        int k = MathHelper.func_76128_c((double)(y - (double)this.top)) - this.headerPadding + (int)this.amountScrolled - 4;
        int l = k / this.slotHeight;
        return x < (double)this.getScrollBarX() && x >= (double)i && x <= (double)j && l >= 0 && k >= 0 && l < this.getSize() ? l : -1;
    }

    protected void bindAmountScrolled() {
        this.amountScrolled = MathHelper.func_151237_a((double)this.amountScrolled, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - (this.bottom - this.top - 4));
    }

    public int getAmountScrolled() {
        return (int)this.amountScrolled;
    }

    public boolean isMouseInList(double p_195079_1_, double p_195079_3_) {
        return p_195079_3_ >= (double)this.top && p_195079_3_ <= (double)this.bottom && p_195079_1_ >= (double)this.left && p_195079_1_ <= (double)this.right;
    }

    public void scrollBy(int amount) {
        this.amountScrolled += (double)amount;
        this.bindAmountScrolled();
        this.initialClickY = -2;
    }

    public void drawScreen(int mouseXIn, int mouseYIn, float partialTicks) {
        if (this.visible) {
            this.drawBackground();
            int i = this.getScrollBarX();
            int j = i + 6;
            this.bindAmountScrolled();
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer bufferbuilder = tessellator.func_178180_c();
            this.drawContainerBackground(tessellator);
            int k = this.left + this.width / 2 - this.getListWidth() / 2 + 2;
            int l = this.top + 4 - (int)this.amountScrolled;
            if (this.hasListHeader) {
                this.drawListHeader(k, l, tessellator);
            }
            this.drawSelectionBox(k, l, mouseXIn, mouseYIn, partialTicks);
            GlStateManager.func_179097_i();
            this.overlayBackground(0, this.top, 255, 255);
            this.overlayBackground(this.bottom, this.height, 255, 255);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)0, (int)1);
            GlStateManager.func_179118_c();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179090_x();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b((double)this.left, (double)(this.top + 4), 0.0).func_181673_a(0.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_181662_b((double)this.right, (double)(this.top + 4), 0.0).func_181673_a(1.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_181662_b((double)this.right, (double)this.top, 0.0).func_181673_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b((double)this.left, (double)this.top, 0.0).func_181673_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b((double)this.left, (double)this.bottom, 0.0).func_181673_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b((double)this.right, (double)this.bottom, 0.0).func_181673_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b((double)this.right, (double)(this.bottom - 4), 0.0).func_181673_a(1.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_181662_b((double)this.left, (double)(this.bottom - 4), 0.0).func_181673_a(0.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
            int j1 = this.getMaxScroll();
            if (j1 > 0) {
                int k1 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight());
                int l1 = (int)this.amountScrolled * (this.bottom - this.top - (k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.bottom - this.top - 8)))) / j1 + this.top;
                if (l1 < this.top) {
                    l1 = this.top;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)i, (double)this.bottom, 0.0).func_181673_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j, (double)this.bottom, 0.0).func_181673_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j, (double)this.top, 0.0).func_181673_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)i, (double)this.top, 0.0).func_181673_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)i, (double)(l1 + k1), 0.0).func_181673_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j, (double)(l1 + k1), 0.0).func_181673_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j, (double)l1, 0.0).func_181673_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)i, (double)l1, 0.0).func_181673_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)i, (double)(l1 + k1 - 1), 0.0).func_181673_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_181673_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(j - 1), (double)l1, 0.0).func_181673_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)i, (double)l1, 0.0).func_181673_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            this.renderDecorations(mouseXIn, mouseYIn);
            GlStateManager.func_179098_w();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
        }
    }

    protected void checkScrollbarClick(double mouseX, double mouseY, int button) {
        this.clickedScrollbar = button == 0 && mouseX >= (double)this.getScrollBarX() && mouseX < (double)(this.getScrollBarX() + 6);
    }

    @Override
    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.checkScrollbarClick(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.isVisible() && this.isMouseInList(p_mouseClicked_1_, p_mouseClicked_3_)) {
            int i = this.getEntryAt(p_mouseClicked_1_, p_mouseClicked_3_);
            if (i == -1 && p_mouseClicked_5_ == 0) {
                this.clickedHeader((int)(p_mouseClicked_1_ - (double)(this.left + this.width / 2 - this.getListWidth() / 2)), (int)(p_mouseClicked_3_ - (double)this.top) + (int)this.amountScrolled - 4);
                return true;
            }
            if (i != -1 && this.mouseClicked(i, p_mouseClicked_5_, p_mouseClicked_1_, p_mouseClicked_3_)) {
                if (this.getChildren().size() > i) {
                    this.setFocused(this.getChildren().get(i));
                }
                this.setDragging(true);
                this.setSelectedEntry(i);
                return true;
            }
            return this.clickedScrollbar;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }
        this.getChildren().forEach(p_195081_5_ -> p_195081_5_.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_));
        return false;
    }

    @Override
    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_)) {
            return true;
        }
        if (this.isVisible() && p_mouseDragged_5_ == 0 && this.clickedScrollbar) {
            if (p_mouseDragged_3_ < (double)this.top) {
                this.amountScrolled = 0.0;
            } else if (p_mouseDragged_3_ > (double)this.bottom) {
                this.amountScrolled = this.getMaxScroll();
            } else {
                double d0 = this.getMaxScroll();
                if (d0 < 1.0) {
                    d0 = 1.0;
                }
                int i = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight());
                double d1 = d0 / (double)(this.bottom - this.top - (i = MathHelper.func_76125_a((int)i, (int)32, (int)(this.bottom - this.top - 8))));
                if (d1 < 1.0) {
                    d1 = 1.0;
                }
                this.amountScrolled += p_mouseDragged_8_ * d1;
                this.bindAmountScrolled();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double p_mouseScrolled_1_) {
        if (!this.isVisible()) {
            return false;
        }
        this.amountScrolled -= p_mouseScrolled_1_ * (double)this.slotHeight / 2.0;
        return true;
    }

    @Override
    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        return !this.isVisible() ? false : super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        return !this.isVisible() ? false : super.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    public int getListWidth() {
        return 220;
    }

    protected void drawSelectionBox(int insideLeft, int insideTop, int mouseXIn, int mouseYIn, float partialTicks) {
        int i = this.getSize();
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer bufferbuilder = tessellator.func_178180_c();
        for (int j = 0; j < i; ++j) {
            int k = insideTop + j * this.slotHeight + this.headerPadding;
            int l = this.slotHeight - 4;
            if (k > this.bottom || k + l < this.top) {
                this.updateItemPos(j, insideLeft, k, partialTicks);
            }
            if (this.showSelectionBox && this.isSelected(j)) {
                int i1 = this.left + this.width / 2 - this.getListWidth() / 2;
                int j1 = this.left + this.width / 2 + this.getListWidth() / 2;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179090_x();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)i1, (double)(k + l + 2), 0.0).func_181673_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j1, (double)(k + l + 2), 0.0).func_181673_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j1, (double)(k - 2), 0.0).func_181673_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)i1, (double)(k - 2), 0.0).func_181673_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(i1 + 1), (double)(k + l + 1), 0.0).func_181673_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(j1 - 1), (double)(k + l + 1), 0.0).func_181673_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(j1 - 1), (double)(k - 1), 0.0).func_181673_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(i1 + 1), (double)(k - 1), 0.0).func_181673_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
            }
            this.drawSlot(j, insideLeft, k, l, mouseXIn, mouseYIn, partialTicks);
        }
    }

    protected int getScrollBarX() {
        return this.width / 2 + 124;
    }

    protected void overlayBackground(int startY, int endY, int startAlpha, int endAlpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer bufferbuilder = tessellator.func_178180_c();
        this.mc.func_110434_K().func_110577_a(Gui.field_110325_k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b((double)this.left, (double)endY, 0.0).func_181673_a(0.0, (double)((float)endY / 32.0f)).func_181669_b(64, 64, 64, endAlpha).func_181675_d();
        bufferbuilder.func_181662_b((double)(this.left + this.width), (double)endY, 0.0).func_181673_a((double)((float)this.width / 32.0f), (double)((float)endY / 32.0f)).func_181669_b(64, 64, 64, endAlpha).func_181675_d();
        bufferbuilder.func_181662_b((double)(this.left + this.width), (double)startY, 0.0).func_181673_a((double)((float)this.width / 32.0f), (double)((float)startY / 32.0f)).func_181669_b(64, 64, 64, startAlpha).func_181675_d();
        bufferbuilder.func_181662_b((double)this.left, (double)startY, 0.0).func_181673_a(0.0, (double)((float)startY / 32.0f)).func_181669_b(64, 64, 64, startAlpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public void setSlotXBoundsFromLeft(int leftIn) {
        this.left = leftIn;
        this.right = leftIn + this.width;
    }

    public int getSlotHeight() {
        return this.slotHeight;
    }

    protected void drawContainerBackground(Tessellator tessellator) {
        WorldRenderer buffer = tessellator.func_178180_c();
        this.mc.func_110434_K().func_110577_a(Gui.field_110325_k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float scale = 32.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)this.left, (double)this.bottom, 0.0).func_181673_a((double)((float)this.left / scale), (double)((float)(this.bottom + (int)this.amountScrolled) / scale)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.right, (double)this.bottom, 0.0).func_181673_a((double)((float)this.right / scale), (double)((float)(this.bottom + (int)this.amountScrolled) / scale)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.right, (double)this.top, 0.0).func_181673_a((double)((float)this.right / scale), (double)((float)(this.top + (int)this.amountScrolled) / scale)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.left, (double)this.top, 0.0).func_181673_a((double)((float)this.left / scale), (double)((float)(this.top + (int)this.amountScrolled) / scale)).func_181669_b(32, 32, 32, 255).func_181675_d();
        tessellator.func_78381_a();
    }
}

