/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.gui.elements.RenderScalingText;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderScrollingText
extends RenderScalingText {
    protected int width = 100;
    protected float stepSize = 1.0f;
    protected int speedTime = 20;
    protected int waitTime = 4000;
    protected float moveDifference = 0.0f;
    protected long lastTime = 0L;
    protected State state = State.WAITING;

    public RenderScrollingText(Supplier<FontRenderer> fontRenderSupplier, Supplier<String> textSupplier) {
        super(fontRenderSupplier, textSupplier);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setSpeedTime(int speedtime) {
        this.speedTime = speedtime;
    }

    public int getSpeedTime() {
        return this.speedTime;
    }

    public void setWaitTime(int waittime) {
        this.waitTime = waittime;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    @Override
    protected void updatedText() {
        this.state = State.WAITING;
        this.moveDifference = 0.0f;
        this.lastTime = 0L;
    }

    @Override
    public void draw(float x, float y) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        double scaleFactor = scaledresolution.func_78325_e();
        int nativeX = MathHelper.func_76143_f((double)((double)x * scaleFactor));
        int nativeY = MathHelper.func_76143_f((double)((double)y * scaleFactor));
        int nativeWidth = MathHelper.func_76143_f((double)((double)this.width * scaleFactor));
        int nativeHeight = MathHelper.func_76143_f((double)((double)((float)(((FontRenderer)this.fontRenderSupplier.get()).field_78288_b + 1) * this.scale) * scaleFactor));
        GL11.glPushMatrix();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)nativeX, (int)(mc.field_71440_d - (nativeY + nativeHeight)), (int)nativeWidth, (int)nativeHeight);
        super.draw(this.getMovingX(x), y + 2.0f);
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
    }

    protected float getMovingX(float x) {
        float textWidth = this.getTextWidth();
        if ((float)this.width < textWidth) {
            float maxMove = (float)this.width - textWidth;
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            if (this.state == State.WAITING) {
                if (this.hasWaitTimePassed()) {
                    this.state = this.moveDifference >= 0.0f ? State.LEFT : State.RIGHT;
                    this.lastTime = 0L;
                }
            } else if (this.hasSpeedTimePassed()) {
                if (this.state == State.LEFT ? this.moveDifference >= maxMove : this.moveDifference <= 0.0f) {
                    this.moveDifference += this.state == State.LEFT ? -this.stepSize : this.stepSize;
                } else {
                    this.state = State.WAITING;
                }
                this.lastTime = 0L;
            }
            return x + this.moveDifference;
        }
        return x;
    }

    protected boolean hasWaitTimePassed() {
        return System.currentTimeMillis() - (long)this.waitTime >= this.lastTime;
    }

    protected boolean hasSpeedTimePassed() {
        return System.currentTimeMillis() - (long)this.speedTime >= this.lastTime;
    }

    private static enum State {
        WAITING,
        LEFT,
        RIGHT;

    }
}

