/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.gui.elements.backport.IGuiEventListener;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public class GuiProgressBar
extends Gui
implements IGuiEventListener {
    private Supplier<Double> progress;
    private Consumer<Double> click;
    private int width = 200;
    private int height = 5;
    private int x;
    private int y;
    private int backGroundColor;
    private int progressColor;
    private boolean enabled = true;
    private boolean visible = true;
    private boolean hovered;

    public GuiProgressBar(int x, int y, int width, int height, int backGroundColor, int progressColor, Supplier<Double> progress, Consumer<Double> click) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.backGroundColor = backGroundColor;
        this.progressColor = progressColor;
        this.progress = progress;
        this.click = click;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            GuiProgressBar.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.backGroundColor);
            GuiProgressBar.func_73734_a((int)this.x, (int)this.y, (int)((int)((double)this.x + this.progress.get() * (double)this.width)), (int)(this.y + this.height), (int)this.progressColor);
        }
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.click != null) {
            this.click.accept((mouseX - (double)this.x) / (double)this.width);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isPressable(mouseX, mouseY)) {
            this.playPressSound(Minecraft.func_71410_x().func_147118_V());
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected boolean isPressable(double mouseX, double mouseY) {
        return this.enabled && this.visible && mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }

    public void playPressSound(SoundHandler soundHandler) {
        soundHandler.func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
    }

    public void setProgressSupplier(Supplier<Double> progress) {
        this.progress = progress;
    }

    public double getProgress() {
        return this.progress.get();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public int getBackGroundColor() {
        return this.backGroundColor;
    }

    public void setBackGroundColor(int backGroundColor) {
        this.backGroundColor = backGroundColor;
    }

    public int getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(int progressColor) {
        this.progressColor = progressColor;
    }

    public void setClick(Consumer<Double> click) {
        this.click = click;
    }
}

