/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist;

import info.u_team.music_player.gui.playlist.GuiMusicPlaylistList;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryPlayable;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.music_player.util.WrappedObject;
import info.u_team.u_team_core.gui.elements.GuiButtonClickImage;
import net.minecraft.client.Minecraft;

abstract class GuiMusicPlaylistListEntryFunctions
extends GuiMusicPlaylistListEntryPlayable {
    protected final Playlist playlist;
    protected final WrappedObject<String> uri;
    protected final GuiButtonClickImage deleteTrackButton;
    protected final GuiButtonClickImage upButton;
    protected final GuiButtonClickImage downButton;

    GuiMusicPlaylistListEntryFunctions(GuiMusicPlaylistList guilist, Playlists playlists, Playlist playlist, LoadedTracks loadedTrack, IAudioTrack track) {
        super(playlists, playlist, loadedTrack, track);
        this.playlist = playlist;
        this.uri = loadedTrack.getUri();
        this.deleteTrackButton = this.addButton(new GuiButtonClickImage(0, 0, 20, 20, MusicPlayerResources.textureClear));
        this.upButton = this.addButton(new GuiButtonClickImage(0, 0, 20, 10, MusicPlayerResources.textureUp));
        this.downButton = this.addButton(new GuiButtonClickImage(0, 0, 20, 10, MusicPlayerResources.textureDown));
        this.deleteTrackButton.setClickAction(() -> {
            playlist.remove(this.uri);
            guilist.updateAllEntries();
        });
        this.upButton.setClickAction(() -> {
            playlist.move(this.uri, 1);
            guilist.setSelectedEntryWhenMove(this.index - 1);
            guilist.updateAllEntries();
        });
        this.downButton.setClickAction(() -> {
            playlist.move(this.uri, -1);
            guilist.setSelectedEntryWhenMove(this.index + 1);
            guilist.updateAllEntries();
        });
    }

    @Override
    public void drawEntry(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean mouseInList, float partialTicks) {
        super.drawEntry(entryWidth, entryHeight, mouseX, mouseY, mouseInList, partialTicks);
        this.drawEntryExtended(entryWidth, entryHeight, mouseX, mouseY, mouseInList, partialTicks);
        this.deleteTrackButton.field_146128_h = entryWidth - 15;
        this.deleteTrackButton.field_146129_i = this.getY() + 8;
        this.deleteTrackButton.func_146112_a(Minecraft.func_71410_x(), mouseX, mouseY);
        this.upButton.field_146128_h = entryWidth - 40;
        this.upButton.field_146129_i = this.getY() + 8;
        this.upButton.func_146112_a(Minecraft.func_71410_x(), mouseX, mouseY);
        this.downButton.field_146128_h = entryWidth - 40;
        this.downButton.field_146129_i = this.getY() + 18;
        this.downButton.func_146112_a(Minecraft.func_71410_x(), mouseX, mouseY);
    }

    public abstract void drawEntryExtended(int var1, int var2, int var3, int var4, boolean var5, float var6);
}

