/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.controls;

import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiMusicProgressBar;
import info.u_team.music_player.gui.ingame.GuiIngameMenuCustom;
import info.u_team.music_player.gui.settings.GuiMusicPlayerSettings;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.MusicPlayerUtils;
import info.u_team.music_player.musicplayer.settings.Repeat;
import info.u_team.music_player.musicplayer.settings.Settings;
import info.u_team.u_team_core.gui.elements.GuiButtonClickImage;
import info.u_team.u_team_core.gui.elements.GuiButtonClickImageActivated;
import info.u_team.u_team_core.gui.elements.GuiButtonClickImageToggle;
import info.u_team.u_team_core.gui.elements.GuiSliderBetterFont;
import info.u_team.u_team_core.gui.elements.RenderScrollingText;
import info.u_team.u_team_core.gui.elements.backport.GuiButtonNew;
import info.u_team.u_team_core.gui.elements.backport.GuiEventHandlerNew;
import info.u_team.u_team_core.gui.elements.backport.IGuiEventListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class GuiControls
extends GuiEventHandlerNew {
    private final int middleX;
    private final int y;
    private final int width;
    private final boolean small;
    private final int buttonSize;
    private final int halfButtonSize;
    private final List<GuiButtonNew> buttons;
    private final List<GuiButtonNew> disableButtons;
    private final List<IGuiEventListener> children;
    private final ITrackManager manager;
    private final GuiButtonClickImageToggle playButton;
    private final GuiMusicProgressBar songProgress;
    private RenderScrollingText titleRender;
    private RenderScrollingText authorRender;

    public GuiControls(GuiScreen gui, int y, int width) {
        boolean isIngame;
        this.y = y;
        this.width = width;
        this.middleX = width / 2;
        this.buttons = new ArrayList<GuiButtonNew>();
        this.disableButtons = new ArrayList<GuiButtonNew>();
        this.children = new ArrayList<IGuiEventListener>();
        this.manager = MusicPlayerManager.getPlayer().getTrackManager();
        Minecraft mc = Minecraft.func_71410_x();
        boolean isSettings = gui instanceof GuiMusicPlayerSettings;
        this.small = isIngame = gui instanceof GuiIngameMenuCustom;
        this.buttonSize = this.small ? 15 : 20;
        this.halfButtonSize = this.buttonSize / 2;
        this.playButton = this.addButton(new GuiButtonClickImageToggle(this.middleX - this.halfButtonSize, y, this.buttonSize, this.buttonSize, MusicPlayerResources.texturePlay, MusicPlayerResources.texturePause));
        this.playButton.toggle(!this.manager.isPaused());
        this.playButton.setToggleClickAction(play -> this.manager.setPaused(play == false));
        GuiButtonClickImage skipForwardButton = this.addButton(new GuiButtonClickImage(this.middleX + this.halfButtonSize + 5, y, this.buttonSize, this.buttonSize, MusicPlayerResources.textureSkipForward));
        skipForwardButton.setClickAction(() -> MusicPlayerUtils.skipForward());
        GuiButtonClickImage skipBackButton = this.addButton(new GuiButtonClickImage(this.middleX - (this.buttonSize + this.halfButtonSize + 5), y, this.buttonSize, this.buttonSize, MusicPlayerResources.textureSkipBack));
        skipBackButton.setClickAction(() -> MusicPlayerUtils.skipBack());
        Settings settings = MusicPlayerManager.getSettingsManager().getSettings();
        GuiButtonClickImageActivated shuffleButton = this.addButton(new GuiButtonClickImageActivated(this.middleX - (2 * this.buttonSize + this.halfButtonSize + 10), y, this.buttonSize, this.buttonSize, MusicPlayerResources.textureShuffle, -2130771713));
        Runnable updateShuffleButton = () -> shuffleButton.setActive(settings.isShuffle());
        updateShuffleButton.run();
        shuffleButton.setClickAction(() -> {
            settings.setShuffle(!settings.isShuffle());
            updateShuffleButton.run();
        });
        GuiButtonClickImageActivated repeatButton = this.addButton(new GuiButtonClickImageActivated(this.middleX + this.buttonSize + this.halfButtonSize + 10, y, this.buttonSize, this.buttonSize, MusicPlayerResources.textureRepeat, -2130771713));
        Runnable updateRepeatButton = () -> {
            repeatButton.setActive(settings.getRepeat().isActive());
            repeatButton.setResource(settings.getRepeat().getResource());
        };
        updateRepeatButton.run();
        repeatButton.setClickAction(() -> {
            settings.setRepeat(Repeat.forwardCycle(settings.getRepeat()));
            updateRepeatButton.run();
        });
        this.songProgress = new GuiMusicProgressBar(this.manager, this.middleX - (this.small ? 50 : 100), y + (this.small ? 20 : 30), this.small ? 100 : 200, this.small ? 3 : 5, this.small ? 0.5f : 1.0f);
        this.children.add(this.songProgress);
        if (!isSettings) {
            GuiButtonClickImage settingsButton = this.addButtonNonDisable(new GuiButtonClickImage(width - 16, 1, 15, 15, MusicPlayerResources.textureSettings));
            settingsButton.setClickAction(() -> mc.func_147108_a((GuiScreen)new GuiMusicPlayerSettings(gui)));
        }
        if (isIngame) {
            GuiButtonClickImage guiButton = this.addButtonNonDisable(new GuiButtonClickImage(width - 32, 1, 15, 15, MusicPlayerResources.textureOpen));
            guiButton.setClickAction(() -> mc.func_147108_a((GuiScreen)new GuiMusicPlayer()));
        }
        int volumeY = width - (70 + (isIngame ? 33 : (!isSettings ? 17 : 1)));
        this.addButtonNonDisable(new GuiSliderBetterFont(-1, volumeY, 1, 70, 15, MusicPlayerLocalization.getTranslation("gui.controls.volume", new Object[0]) + ": ", "%", 0.0, 100.0, settings.getVolume(), false, true, 0.7f, slider -> {
            settings.setVolume(slider.getValueInt());
            MusicPlayerManager.getPlayer().setVolume(settings.getVolume());
        }));
        this.titleRender = new RenderScrollingText(() -> mc.field_71466_p, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedTitle()));
        this.titleRender.setStepSize(0.5f);
        this.titleRender.setColor(0xFFFF00);
        this.titleRender.setSpeedTime(35);
        this.authorRender = new RenderScrollingText(() -> mc.field_71466_p, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedAuthor()));
        this.authorRender.setStepSize(0.5f);
        this.authorRender.setColor(0xFFFF00);
        this.authorRender.setScale(0.75f);
        this.authorRender.setSpeedTime(35);
        this.disableButtons.forEach(button -> {
            button.field_146124_l = false;
        });
        this.buttons.forEach(this.children::add);
        this.tick();
    }

    public void tick() {
        if (this.manager.getCurrentTrack() == null) {
            this.disableButtons.forEach(button -> {
                button.field_146124_l = false;
            });
        } else {
            this.disableButtons.forEach(button -> {
                button.field_146124_l = true;
            });
        }
        this.playButton.toggle(!this.manager.isPaused());
    }

    @Override
    protected List<? extends IGuiEventListener> getChildren() {
        return this.children;
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.buttons.forEach(button -> button.func_146112_a(Minecraft.func_71410_x(), mouseX, mouseY));
        this.songProgress.render(mouseX, mouseY, partialTicks);
        int textRenderWidth = this.middleX - (2 * this.buttonSize + this.halfButtonSize + 10) - (this.small ? 15 : 35);
        this.titleRender.setWidth(textRenderWidth);
        this.authorRender.setWidth(textRenderWidth);
        int textRenderY = this.small ? this.y : this.y + 2;
        this.titleRender.draw(this.small ? 10.0f : 25.0f, textRenderY);
        this.authorRender.draw(this.small ? 10.0f : 25.0f, textRenderY + 10);
    }

    private <B extends GuiButtonNew> B addButton(B button) {
        this.buttons.add(button);
        this.disableButtons.add(button);
        return button;
    }

    private <B extends GuiButtonNew> B addButtonNonDisable(B button) {
        this.buttons.add(button);
        return button;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public RenderScrollingText getTitleRender() {
        return this.titleRender;
    }

    public void setTitleRender(RenderScrollingText titleRender) {
        this.titleRender = titleRender;
    }

    public RenderScrollingText getAuthorRender() {
        return this.authorRender;
    }

    public void setAuthorRender(RenderScrollingText authorRender) {
        this.authorRender = authorRender;
    }
}

