/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.event;

import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.ingame.GuiIngameMenuCustom;
import info.u_team.music_player.init.MusicPlayerKeys;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.MusicPlayerUtils;
import info.u_team.music_player.musicplayer.settings.IngameOverlayPosition;
import info.u_team.music_player.musicplayer.settings.Settings;
import info.u_team.music_player.render.RenderOverlayMusicDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Keyboard;

public class EventHandlerMusicPlayer {
    private final Settings settings;
    private RenderOverlayMusicDisplay overlayRender;

    public EventHandlerMusicPlayer(Settings settings) {
        this.settings = settings;
    }

    @SubscribeEvent
    public void on(InputEvent.KeyInputEvent event) {
        this.handleKeyboard(false, -1);
    }

    @SubscribeEvent
    public void on(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (this.settings.isKeyWorkInGui() && Keyboard.getEventKeyState()) {
            event.setCanceled(this.handleKeyboard(true, Keyboard.getEventKey()));
        }
    }

    private boolean handleKeyboard(boolean gui, int keyCode) {
        boolean handled;
        ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isKeyDown(MusicPlayerKeys.open, gui, keyCode)) {
            if (!(mc.field_71462_r instanceof GuiMusicPlayer)) {
                mc.func_147108_a((GuiScreen)new GuiMusicPlayer());
            }
            handled = true;
        } else if (this.isKeyDown(MusicPlayerKeys.pause, gui, keyCode)) {
            if (manager.getCurrentTrack() != null) {
                manager.setPaused(!manager.isPaused());
            }
            handled = true;
        } else if (this.isKeyDown(MusicPlayerKeys.skipForward, gui, keyCode)) {
            if (manager.getCurrentTrack() != null) {
                MusicPlayerUtils.skipForward();
            }
            handled = true;
        } else if (this.isKeyDown(MusicPlayerKeys.skipBack, gui, keyCode)) {
            if (manager.getCurrentTrack() != null) {
                MusicPlayerUtils.skipBack();
            }
            handled = true;
        } else {
            handled = false;
        }
        if (handled) {
            mc.func_152348_aa();
        }
        return handled;
    }

    private boolean isKeyDown(KeyBinding binding, boolean gui, int keyCode) {
        if (gui) {
            return keyCode != 0 && keyCode == binding.func_151463_i();
        }
        return binding.func_151468_f();
    }

    @SubscribeEvent
    public void on(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.type == RenderGameOverlayEvent.ElementType.TEXT && !mc.field_71474_y.field_74330_P && mc.field_71462_r == null && this.settings.isShowIngameOverlay()) {
            if (this.overlayRender == null) {
                this.overlayRender = new RenderOverlayMusicDisplay();
            }
            IngameOverlayPosition position = this.settings.getIngameOverlayPosition();
            ScaledResolution scaledResolution = new ScaledResolution(mc);
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int x = position.isLeft() ? 3 : width - 3 - this.overlayRender.getWidth();
            int y = position.isUp() ? 3 : height - 3 - this.overlayRender.getHeight();
            this.overlayRender.draw(x, y);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void on(GuiScreenEvent.InitGuiEvent.Pre event) {
        GuiScreen gui = event.gui;
        if (gui instanceof GuiIngameMenu && this.settings.isShowIngameMenueOverlay()) {
            gui.field_146297_k.func_147108_a((GuiScreen)new GuiIngameMenuCustom());
        }
    }
}

