/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist;

import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntry;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryError;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryPlaylistStart;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.u_team_core.gui.elements.GuiButtonClickImageToggle;
import net.minecraft.client.Minecraft;

public abstract class GuiMusicPlaylistListEntryPlayable
extends GuiMusicPlaylistListEntry {
    private final ITrackManager manager;
    private final IAudioTrack track;
    private final LoadedTracks loadedTrack;
    protected final GuiButtonClickImageToggle playTrackButton;

    GuiMusicPlaylistListEntryPlayable(Playlists playlists, Playlist playlist, LoadedTracks loadedTrack, IAudioTrack track) {
        this.track = track;
        this.loadedTrack = loadedTrack;
        this.manager = MusicPlayerManager.getPlayer().getTrackManager();
        this.playTrackButton = this.addButton(new GuiButtonClickImageToggle(0, 0, 20, 20, MusicPlayerResources.texturePlay, MusicPlayerResources.texturePause));
        if (loadedTrack.hasError() || track == null) {
            this.playTrackButton.field_146125_m = false;
        } else {
            this.playTrackButton.toggle(track == this.getCurrentlyPlaying());
            this.playTrackButton.setToggleClickAction(play -> {
                if (play.booleanValue()) {
                    if (this.manager.isPaused() && this.getCurrentlyPlaying() == track) {
                        this.manager.setPaused(false);
                    } else {
                        playlists.setPlaying(playlist);
                        playlist.setPlayable(loadedTrack, track);
                        this.manager.setTrackQueue(playlist);
                        this.manager.start();
                    }
                } else {
                    this.manager.setPaused(true);
                }
            });
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 2) {
            String uri;
            String string = uri = this instanceof GuiMusicPlaylistListEntryPlaylistStart || this instanceof GuiMusicPlaylistListEntryError ? this.loadedTrack.getUri().get() : this.track.getInfo().getURI();
            if (GuiTrackUtils.openURI(uri)) {
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void drawEntry(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean mouseInList, float partialTicks) {
        this.playTrackButton.field_146128_h = entryWidth - 65;
        this.playTrackButton.field_146129_i = this.getY() + 8;
        this.playTrackButton.func_146112_a(Minecraft.func_71410_x(), mouseX, mouseY);
    }

    @Override
    protected void tick() {
        if (this.isPlaying()) {
            this.playTrackButton.toggle(!this.manager.isPaused());
        } else {
            this.playTrackButton.toggle(false);
        }
    }

    protected IAudioTrack getCurrentlyPlaying() {
        return this.manager.getCurrentTrack() == null ? null : this.manager.getCurrentTrack().getOriginalTrack();
    }

    protected boolean isPlaying() {
        return this.getCurrentlyPlaying() == this.track;
    }

    public IAudioTrack getTrack() {
        return this.track;
    }

    public GuiButtonClickImageToggle getPlayTrackButton() {
        return this.playTrackButton;
    }
}

