/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui;

import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.GuiMusicPlayerList;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.music_player.musicplayer.playlist.Skip;
import info.u_team.u_team_core.gui.elements.GuiButtonClickImage;
import info.u_team.u_team_core.gui.elements.GuiButtonClickImageToggle;
import info.u_team.u_team_core.gui.elements.GuiScrollableListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import org.apache.commons.lang3.tuple.Pair;

class GuiMusicPlayerListEntry
extends GuiScrollableListEntry<GuiMusicPlayerListEntry> {
    private final Playlists playlists;
    private final Playlist playlist;
    private final GuiButtonClickImageToggle playPlaylistButton;
    private final GuiButtonClickImage openPlaylistButton;
    private final GuiButtonClickImage deletePlaylistButton;

    public GuiMusicPlayerListEntry(GuiMusicPlayerList gui, Playlists playlists, Playlist playlist) {
        this.playlists = playlists;
        this.playlist = playlist;
        this.playPlaylistButton = this.addButton(new GuiButtonClickImageToggle(0, 0, 20, 20, MusicPlayerResources.texturePlay, MusicPlayerResources.textureStop));
        this.playPlaylistButton.toggle(playlist.equals(playlists.getPlaying()));
        this.playPlaylistButton.field_146124_l = !playlists.isPlayingLock();
        this.playPlaylistButton.setToggleClickAction(play -> {
            if (playlists.isPlayingLock()) {
                return;
            }
            playlists.setPlaying(null);
            gui.getChildren().stream().filter(entry -> entry != this).forEach(entry -> entry.playPlaylistButton.toggle(false));
            Runnable runnable = () -> {
                ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
                if (play.booleanValue()) {
                    if (!playlist.isEmpty()) {
                        playlists.setPlaying(playlist);
                        Pair<LoadedTracks, IAudioTrack> pair = playlist.getFirstTrack();
                        playlist.setPlayable((LoadedTracks)pair.getLeft(), (IAudioTrack)pair.getRight());
                        if (((LoadedTracks)pair.getLeft()).hasError() || pair.getRight() == null) {
                            playlist.skip(Skip.FORWARD);
                        }
                        manager.setTrackQueue(playlist);
                        manager.start();
                    } else {
                        playlists.setPlaying(null);
                        playlist.setStopable();
                        manager.stop();
                        this.playPlaylistButton.toggle(false);
                    }
                } else {
                    playlists.setPlaying(null);
                    playlist.setStopable();
                    manager.stop();
                }
                playlists.removePlayingLock();
                if (this.mc.field_71462_r instanceof GuiMusicPlayer) {
                    GuiMusicPlayer musicplayergui = (GuiMusicPlayer)this.mc.field_71462_r;
                    GuiMusicPlayerList newGui = musicplayergui.getPlaylistsList();
                    newGui.getChildren().forEach(entry -> {
                        entry.playPlaylistButton.field_146124_l = true;
                    });
                } else if (this.mc.field_71462_r instanceof GuiMusicPlaylist) {
                    GuiMusicPlaylist musicplaylistgui = (GuiMusicPlaylist)this.mc.field_71462_r;
                    musicplaylistgui.getTrackList().updateAllEntries();
                }
            };
            gui.getChildren().forEach(entry -> {
                entry.playPlaylistButton.field_146124_l = false;
            });
            playlists.setPlayingLock();
            if (!playlist.isLoaded()) {
                playlist.load(runnable);
            } else {
                runnable.run();
            }
        });
        this.openPlaylistButton = this.addButton(new GuiButtonClickImage(0, 0, 20, 20, MusicPlayerResources.textureOpen));
        this.openPlaylistButton.setClickAction(() -> this.mc.func_147108_a((GuiScreen)new GuiMusicPlaylist(playlist)));
        this.deletePlaylistButton = this.addButton(new GuiButtonClickImage(0, 0, 20, 20, MusicPlayerResources.textureClear));
        this.deletePlaylistButton.setClickAction(() -> gui.removePlaylist(this));
    }

    @Override
    public void drawEntry(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean mouseInList, float partialTicks) {
        String name = this.playlist.getName();
        if (name.isEmpty()) {
            name = "\u00a7o" + MusicPlayerLocalization.getTranslation("gui.musicplayer.playlists.no_name", new Object[0]);
        }
        this.mc.field_71466_p.func_78276_b(name, this.getX() + 5, this.getY() + 5, this.playlist.equals(this.playlists.getPlaying()) ? 33791 : 0xFFF00F);
        this.mc.field_71466_p.func_78276_b(this.playlist.getEntrySize() + " " + MusicPlayerLocalization.getTranslation(this.playlist.getEntrySize() > 1 ? "gui.musicplayer.playlists.entries" : "gui.musicplayer.playlists.entry", new Object[0]), this.getX() + 5, this.getY() + 30, 0xFFFFFF);
        this.playPlaylistButton.field_146128_h = entryWidth - 65;
        this.playPlaylistButton.field_146129_i = this.getY() + 12;
        this.playPlaylistButton.func_146112_a(Minecraft.func_71410_x(), mouseX, mouseY);
        this.openPlaylistButton.field_146128_h = entryWidth - 40;
        this.openPlaylistButton.field_146129_i = this.getY() + 12;
        this.openPlaylistButton.func_146112_a(Minecraft.func_71410_x(), mouseX, mouseY);
        this.deletePlaylistButton.field_146128_h = entryWidth - 15;
        this.deletePlaylistButton.field_146129_i = this.getY() + 12;
        this.deletePlaylistButton.func_146112_a(Minecraft.func_71410_x(), mouseX, mouseY);
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }
}

