package info.u_team.gjeb.mixin;

import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_7172;
import net.minecraft.class_7172.class_7176;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;

@Mixin(class_315.class)
abstract class OptionsMixin {
	
	@Shadow
	@Final
	@Mutable
	public class_7172<Double> gamma;
	
	@Redirect(method = "<init>", at = @At(value = "FIELD", target = "Lnet/minecraft/client/Options;gamma:Lnet/minecraft/client/OptionInstance;", opcode = Opcodes.PUTFIELD))
	private void gjeb_replaceGammaOption(class_315 options, class_7172<?> instance) {
		gamma = new class_7172<>("options.gamma", class_7172.method_42399(), (component, value) -> {
			final int intValue = (int) (value * 100);
			if (intValue == 0) {
				return class_315.method_41783(component, class_2561.method_43471("options.gamma.min"));
			} else if (intValue == 50) {
				return class_315.method_41783(component, class_2561.method_43471("options.gamma.default"));
			} else {
				return intValue == 1000 ? class_315.method_41783(component, class_2561.method_43471("options.gamma.max")) : class_315.method_41782(component, intValue);
			}
		}, new class_7176<>() {
			
			@Override
			public Optional<Double> validateValue(Double value) {
				return value >= 0 && value <= 10 ? Optional.of(value) : Optional.empty();
			}
			
			@Override
			public double toSliderValue(Double value) {
				return value / 10D;
			}
			
			@Override
			public Double method_41763(double sliderValue) {
				return sliderValue * 10D;
			}
			
			@Override
			public Codec<Double> comp_675() {
				return Codec.either(Codec.doubleRange(0, 10), Codec.BOOL).xmap(either -> {
					return either.map(value -> {
						return value;
					}, leftRight -> {
						return leftRight ? 10D : 0D;
					});
				}, Either::left);
			}
		}, 0.5D, onValueUpdate -> {
		});
	}
	
}
